/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;

/**
 *
 * @author gevirl
 */
public class DBSCAN  {
    DataFrame df;
    String[] clusterLabels;
    int nClusters;
    
    public DBSCAN(DataFrame df){
        this.df = df;
        
    }
    public String[] getClusterLabels(){
        return this.clusterLabels;
    }
    public int cluster(double eps,int minPts,double[][] x,DistanceMeasure measure){
        ArrayList<Clusterable> collect = new ArrayList<>();
        int i=0;
        for (double[] row : x){
            collect.add(new LabeledClusterable(row,i));
            ++i;
        }
        
        DBSCANClusterer clusterer = new DBSCANClusterer(eps,minPts,measure);

        List<Cluster> clusters = clusterer.cluster(collect);
        int nClusters = clusters.size();
        System.out.printf("Number of Clusters: %d\n",clusters.size());
        
        clusterLabels = new String[x.length];
        i=1;
        for (Cluster cluster : clusters){
            
            String label = Integer.toString(i);
            ++i;
            System.out.printf("Cluster %s: %d points\n", label,cluster.getPoints().size());
            for (Object obj : cluster.getPoints()){
                LabeledClusterable clusterable = (LabeledClusterable)obj;
                clusterLabels[clusterable.getLabel()] = label;
            }
        }
        return nClusters;// return the number of clusters
    }

}
