/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.LMS.dataframe.FileDataFrame;
import org.rhwlab.LMS.dataframe.investigator.Investigation;
import org.rhwlab.LMS.dataframe.TsneFrame;

/**
 *
 * @author gevirl
 */
public class ClusteringPanel extends JPanel {
    TsneFrame parent;
    ClusteringDefinitionPanel defPanel;
    JList list;
    FileDataFrame df;
    JButton remove;
    
    public ClusteringPanel(FileDataFrame df,TsneFrame parent){
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.df = df;
        defPanel = new ClusteringDefinitionPanel(df,this);
        this.add(defPanel,BorderLayout.WEST);
        
        JPanel south = new JPanel();
        GroupLayout southlayout = new GroupLayout(south);
        southlayout.setAutoCreateGaps(true);
        southlayout.setAutoCreateContainerGaps(true);
        remove = new JButton("Remove Selected");
        remove.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                removeSelected();
            }
        });
        southlayout.setHorizontalGroup(southlayout.createSequentialGroup().addComponent(remove));
        southlayout.setVerticalGroup(southlayout.createParallelGroup().addComponent(remove));
        this.add(south,BorderLayout.SOUTH);
         
         
        list = new JList();
        JScrollPane scroll = new JScrollPane(list);
        this.add(scroll,BorderLayout.CENTER);
        
        setDataFrame(df);

    }
    
    private void removeSelected(){
        Object sel = list.getSelectedValue();
        int n = list.getSelectedIndex();
        if (sel != null){
            String s = (String)sel;
            int i = df.removeColumn(Integer.toString(s.hashCode()));
            df.removeComment(n);
        }
        setDataFrame(df);
    }

    // being notified of a new clusterinng
    public void addCluster(String s){
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.addElement(s);
        list.setSelectedValue(s, true);
        parent.updateCanvas(Integer.toString(s.hashCode()));
        df.addComment(s);
    }
    
    private void updateView(){
        String s = (String)list.getSelectedValue();
        if (s == null) {
            parent.updateCanvas(null);
        } else {
            parent.updateCanvas(Integer.toString(s.hashCode()));
        }
    }
    public void setDataFrame(FileDataFrame df){
        this.df = df;
        DefaultListModel model = new DefaultListModel();
        for (String comment : df.getComments()){
            model.addElement(comment);
        }
        list.setModel(model);
        list.addListSelectionListener(new ListSelectionListener(){
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()){
                    
                    updateView();
                }
            }
        });
        defPanel.setDataframe(df);
        this.invalidate();
    }
    public void refresh(){
        this.parent.invalidate();
        this.parent.validate();
    }
}
