/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class BoundedSortedSet<V>
extends TreeSet<V> {
    private static final long serialVersionUID = -4774987058243433217L;
    private final int maxSize;

    public BoundedSortedSet(int max) {
        this.maxSize = max;
    }

    public BoundedSortedSet(int max, Comparator<? super V> cmp) {
        super(cmp);
        this.maxSize = max;
    }

    @Override
    public boolean add(V e) {
        super.add(e);
        if (this.size() > this.maxSize) {
            this.remove(this.last());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> clctn) {
        super.addAll(clctn);
        while (this.size() > this.maxSize) {
            this.remove(this.last());
        }
        return true;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

