/*
 * Decompiled with CFR 0.152.
 */
package jsat.text;

import java.util.List;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.linear.SparseVector;
import jsat.linear.Vec;
import jsat.text.TextDataLoader;
import jsat.text.tokenizer.Tokenizer;
import jsat.text.wordweighting.WordWeighting;
import jsat.utils.IntList;

public abstract class ClassificationTextDataLoader
extends TextDataLoader {
    private static final long serialVersionUID = -3826551504785236576L;
    protected final List<Integer> classLabels = new IntList();
    protected CategoricalData labelInfo;

    public ClassificationTextDataLoader(Tokenizer tokenizer, WordWeighting weighting) {
        super(tokenizer, weighting);
    }

    protected abstract void setLabelInfo();

    @Override
    protected int addOriginalDocument(String text) {
        throw new UnsupportedOperationException("addOriginalDocument(String text, int label) should be used instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addOriginalDocument(String text, int label) {
        if (label >= this.labelInfo.getNumOfCategories()) {
            throw new RuntimeException("Invalid label given");
        }
        int index = super.addOriginalDocument(text);
        List<Integer> list = this.classLabels;
        synchronized (list) {
            while (this.classLabels.size() < index) {
                this.classLabels.add(-1);
            }
            if (this.classLabels.size() == index) {
                this.classLabels.add(label);
            } else {
                this.classLabels.set(index, label);
            }
        }
        return index;
    }

    @Override
    public ClassificationDataSet getDataSet() {
        if (!this.noMoreAdding) {
            this.setLabelInfo();
            this.initialLoad();
            this.finishAdding();
        }
        ClassificationDataSet cds = new ClassificationDataSet(((SparseVector)this.vectors.get(0)).length(), new CategoricalData[0], this.labelInfo);
        for (int i = 0; i < this.vectors.size(); ++i) {
            cds.addDataPoint((Vec)this.vectors.get(i), new int[0], this.classLabels.get(i));
        }
        return cds;
    }
}

