/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import jsat.clustering.PAM;
import jsat.clustering.TRIKMEDS;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.Pair;
import jsat.utils.concurrent.AtomicDoubleArray;
import jsat.utils.concurrent.ParallelUtils;
import jsat.utils.random.RandomUtil;

public class BallTree<V extends Vec>
implements IncrementalCollection<V> {
    public static final int DEFAULT_LEAF_SIZE = 40;
    private int leaf_size = 40;
    private DistanceMetric dm;
    private List<V> allVecs;
    private List<Double> cache;
    private ConstructionMethod construction_method;
    private PivotSelection pivot_method;
    private Node root;

    public BallTree() {
        this(new EuclideanDistance(), ConstructionMethod.KD_STYLE, PivotSelection.CENTROID);
    }

    public BallTree(DistanceMetric dm, ConstructionMethod method, PivotSelection pivot_method) {
        this.setConstruction_method(method);
        this.setPivot_method(pivot_method);
        this.setDistanceMetric(dm);
    }

    public BallTree(BallTree toCopy) {
        this(toCopy.dm, toCopy.construction_method, toCopy.pivot_method);
        if (toCopy.allVecs != null) {
            this.allVecs = new ArrayList<V>(toCopy.allVecs);
        }
        if (toCopy.cache != null) {
            this.cache = new DoubleList(toCopy.cache);
        }
        if (toCopy.root != null) {
            this.root = super.cloneChangeContext(toCopy.root);
        }
        this.leaf_size = toCopy.leaf_size;
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    public void setLeafSize(int leaf_size) {
        if (leaf_size < 2) {
            throw new IllegalArgumentException("The leaf size must be >= 2 to support all splitting methods");
        }
        this.leaf_size = leaf_size;
    }

    public int getLeafSize() {
        return this.leaf_size;
    }

    public void setPivot_method(PivotSelection pivot_method) {
        this.pivot_method = pivot_method;
    }

    public PivotSelection getPivot_method() {
        return this.pivot_method;
    }

    public void setConstruction_method(ConstructionMethod construction_method) {
        this.construction_method = construction_method;
    }

    public ConstructionMethod getConstruction_method() {
        return this.construction_method;
    }

    private Node build_far_top_down(List<Integer> points, boolean parallel) {
        Branch branch = new Branch();
        branch.setPivot(points);
        branch.setRadius(points);
        int f1 = ParallelUtils.streamP(points.stream(), (boolean)parallel).map((Function<Integer, IndexDistPair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build_far_top_down$102(jsat.linear.vectorcollection.BallTree$Branch java.lang.Integer ), (Ljava/lang/Integer;)Ljsat/linear/vectorcollection/IndexDistPair;)((BallTree)this, (Branch)branch)).max((Comparator<IndexDistPair>)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareTo(jsat.linear.vectorcollection.IndexDistPair ), (Ljsat/linear/vectorcollection/IndexDistPair;Ljsat/linear/vectorcollection/IndexDistPair;)I)()).orElse((IndexDistPair)new IndexDistPair((int)0, (double)0.0)).indx;
        int f2 = ParallelUtils.streamP(points.stream(), (boolean)parallel).map((Function<Integer, IndexDistPair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$build_far_top_down$103(int java.lang.Integer ), (Ljava/lang/Integer;)Ljsat/linear/vectorcollection/IndexDistPair;)((BallTree)this, (int)f1)).max((Comparator<IndexDistPair>)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareTo(jsat.linear.vectorcollection.IndexDistPair ), (Ljsat/linear/vectorcollection/IndexDistPair;Ljsat/linear/vectorcollection/IndexDistPair;)I)()).orElse((IndexDistPair)new IndexDistPair((int)1, (double)0.0)).indx;
        IntList left_children = new IntList();
        IntList right_children = new IntList();
        for (int p : points) {
            double d_f2;
            double d_f1 = this.dm.dist(p, f1, this.allVecs, this.cache);
            if (d_f1 < (d_f2 = this.dm.dist(p, f2, this.allVecs, this.cache))) {
                left_children.add(p);
                continue;
            }
            right_children.add(p);
        }
        branch.left_child = this.build(left_children, parallel);
        branch.right_child = this.build(right_children, parallel);
        return branch;
    }

    private Node build_kd(List<Integer> points, boolean parallel) {
        int midPoint;
        int D = ((Vec)this.allVecs.get(0)).length();
        AtomicDoubleArray mins = new AtomicDoubleArray(D);
        mins.fill(Double.POSITIVE_INFINITY);
        AtomicDoubleArray maxs = new AtomicDoubleArray(D);
        maxs.fill(Double.NEGATIVE_INFINITY);
        ParallelUtils.streamP(points.stream(), parallel).forEach(i -> {
            for (IndexValue iv : this.get((int)i)) {
                int d = iv.getIndex();
                mins.updateAndGet(d, m_d -> Math.min(m_d, iv.getValue()));
                maxs.updateAndGet(d, m_d -> Math.max(m_d, iv.getValue()));
            }
        });
        IndexDistPair maxSpread = ParallelUtils.range(D, parallel).mapToObj(d -> new IndexDistPair(d, maxs.get(d) - mins.get(d))).max(IndexDistPair::compareTo).get();
        if (maxSpread.dist == 0.0) {
            Leaf leaf = new Leaf(new IntList(points));
            leaf.setPivot(points);
            leaf.setRadius(points);
            return leaf;
        }
        int d2 = maxSpread.indx;
        points.sort((o1, o2) -> Double.compare(((Vec)this.get((int)o1)).get(d2), ((Vec)this.get((int)o2)).get(d2)));
        for (midPoint = points.size() / 2; midPoint > 1 && ((Vec)this.get(midPoint - 1)).get(d2) == ((Vec)this.get(midPoint)).get(d2); --midPoint) {
        }
        List<Integer> left_children = points.subList(0, midPoint);
        List<Integer> right_children = points.subList(midPoint, points.size());
        Branch branch = new Branch();
        branch.setPivot(points);
        branch.setRadius(points);
        branch.left_child = this.build(left_children, parallel);
        branch.right_child = this.build(right_children, parallel);
        return branch;
    }

    private Node build_anchors(List<Integer> points, boolean parallel) {
        Iterator<Object> iterator;
        int K = (int)Math.ceil(Math.sqrt(points.size()));
        int[] anchor_point_index = new int[K];
        int[] anchor_index = new int[K];
        IntList[] owned = new IntList[K];
        DoubleList[] ownedDist = new DoubleList[K];
        for (int k = 1; k < K; ++k) {
            owned[k] = new IntList();
            ownedDist[k] = new DoubleList();
        }
        Random rand = RandomUtil.getRandom();
        anchor_point_index[0] = rand.nextInt(points.size());
        anchor_index[0] = points.get(anchor_point_index[0]);
        owned[0] = IntList.range(points.size());
        ownedDist[0] = DoubleList.view(ParallelUtils.streamP(owned[0].streamInts(), parallel).mapToDouble(i -> this.dm.dist(anchor_index[0], (Integer)points.get(i), this.allVecs, this.cache)).toArray(), points.size());
        IndexTable it = new IndexTable(ownedDist[0]);
        it.apply(owned[0]);
        it.apply(ownedDist[0]);
        for (int k = 1; k < K; ++k) {
            int max_radius_anch = IntStream.range((int)0, (int)k).mapToObj((IntFunction<IndexDistPair>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$build_anchors$110(jsat.utils.DoubleList[] int ), (I)Ljsat/linear/vectorcollection/IndexDistPair;)((DoubleList[])ownedDist)).max((Comparator<IndexDistPair>)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareTo(jsat.linear.vectorcollection.IndexDistPair ), (Ljsat/linear/vectorcollection/IndexDistPair;Ljsat/linear/vectorcollection/IndexDistPair;)I)()).get().indx;
            anchor_point_index[k] = owned[max_radius_anch].getI(owned[max_radius_anch].size() - 1);
            anchor_index[k] = points.get(anchor_point_index[k]);
            owned[max_radius_anch].remove(owned[max_radius_anch].size() - 1);
            ownedDist[max_radius_anch].remove(ownedDist[max_radius_anch].size() - 1);
            owned[k].add(anchor_point_index[k]);
            ownedDist[k].add(0.0);
            block2: for (int j = 0; j < k; ++j) {
                double dist_ak_aj = this.dm.dist(anchor_index[j], anchor_index[k], this.allVecs, this.cache);
                ListIterator ownedIter = owned[j].listIterator(owned[j].size());
                ListIterator ownedDistIter = ownedDist[j].listIterator(ownedDist[j].size());
                while (ownedIter.hasPrevious()) {
                    int point_indx = (Integer)ownedIter.previous();
                    double dist_aj_x = (Double)ownedDistIter.previous();
                    double dist_ak_x = this.dm.dist(anchor_index[k], points.get(point_indx), this.allVecs, this.cache);
                    if (dist_ak_x < dist_aj_x) {
                        owned[k].add(point_indx);
                        ownedDist[k].add(dist_ak_x);
                        ownedIter.remove();
                        ownedDistIter.remove();
                        continue;
                    }
                    if (!(dist_ak_x < dist_ak_aj / 2.0)) continue;
                    continue block2;
                }
            }
            it = new IndexTable(ownedDist[k]);
            it.apply(owned[k]);
            it.apply(ownedDist[k]);
        }
        ArrayList<Node> anchor_nodes = new ArrayList<Node>();
        for (int k = 0; k < K; ++k) {
            Node n_k = this.build(IntList.view(owned[k].streamInts().map(i -> (Integer)points.get(i)).toArray()), parallel);
            n_k.pivot = this.get(anchor_index[k]);
            n_k.radius = ownedDist[k].getD(ownedDist[k].size() - 1);
            anchor_nodes.add(n_k);
        }
        HashMap<Pair<Integer, Integer>, Double> mergeCost = new HashMap<Pair<Integer, Integer>, Double>();
        HashMap<Pair<Integer, Integer>, Vec> pivotCache = new HashMap<Pair<Integer, Integer>, Vec>();
        ArrayList mergeQs = new ArrayList();
        PriorityQueue<Integer> QQ = new PriorityQueue<Integer>((q1, q2) -> {
            double v1 = (Double)mergeCost.get(((PriorityQueue)mergeQs.get((int)q1)).peek());
            double v2 = (Double)mergeCost.get(((PriorityQueue)mergeQs.get((int)q2)).peek());
            return Double.compare(v1, v2);
        });
        for (int k = 0; k < K; ++k) {
            PriorityQueue<Pair<Integer, Integer>> mergeQ_k = new PriorityQueue<Pair<Integer, Integer>>((o1, o2) -> Double.compare((Double)mergeCost.get(o1), (Double)mergeCost.get(o2)));
            mergeQs.add(mergeQ_k);
            Node n_k = (Node)anchor_nodes.get(k);
            IntList owned_nk = new IntList();
            Iterator iterator2 = n_k.iterator();
            while (iterator2.hasNext()) {
                int i2 = (Integer)iterator2.next();
                owned_nk.add(i2);
            }
            int size_k = owned_nk.size();
            for (int z = k + 1; z < K; ++z) {
                Vec pivot_candidate;
                Node n_z = (Node)anchor_nodes.get(z);
                Pair<Integer, Integer> p = new Pair<Integer, Integer>(k, z);
                IntList owned_nkz = new IntList(owned_nk);
                Iterator iterator3 = n_z.iterator();
                while (iterator3.hasNext()) {
                    int i3 = (Integer)iterator3.next();
                    owned_nkz.add(i3);
                }
                int size_nk = owned_nkz.size();
                int size_z = size_nk - size_k;
                if (this.pivot_method == PivotSelection.CENTROID) {
                    pivot_candidate = n_k.pivot.clone();
                    pivot_candidate.mutableMultiply((double)size_k / (double)size_nk);
                    pivot_candidate.mutableAdd((double)size_z / (double)size_nk, n_z.pivot);
                } else {
                    pivot_candidate = this.pivot_method.getPivot(parallel, owned_nkz, this.allVecs, this.dm, this.cache);
                }
                List<Double> pivor_candidate_qi = this.dm.getQueryInfo(pivot_candidate);
                double radius_kz = 0.0;
                iterator = owned_nkz.iterator();
                while (iterator.hasNext()) {
                    int i4 = (Integer)iterator.next();
                    radius_kz = Math.max(radius_kz, this.dm.dist(i4, pivot_candidate, pivor_candidate_qi, this.allVecs, this.cache));
                }
                mergeCost.put(p, radius_kz);
                pivotCache.put(p, pivot_candidate);
                mergeQ_k.add(p);
            }
            if (mergeQ_k.isEmpty()) continue;
            QQ.add(k);
        }
        Branch toReturn = null;
        while (!QQ.isEmpty()) {
            int winningQ = (Integer)QQ.poll();
            Pair toMerge = (Pair)((PriorityQueue)mergeQs.get(winningQ)).poll();
            int other = (Integer)toMerge.getSecondItem();
            if (anchor_nodes.get(winningQ) == null) continue;
            if (anchor_nodes.get(other) == null) {
                if (((PriorityQueue)mergeQs.get(winningQ)).isEmpty()) continue;
                QQ.add(winningQ);
                continue;
            }
            Branch merged = toReturn = new Branch();
            merged.pivot = (Vec)pivotCache.get(toMerge);
            merged.pivot_qi = this.dm.getQueryInfo(merged.pivot);
            merged.radius = (Double)mergeCost.get(toMerge);
            merged.left_child = (Node)anchor_nodes.get(winningQ);
            merged.right_child = (Node)anchor_nodes.get(other);
            anchor_nodes.set(winningQ, merged);
            anchor_nodes.set(other, null);
            PriorityQueue<Pair<Integer, Integer>> mergeQ_k = new PriorityQueue<Pair<Integer, Integer>>((o1, o2) -> Double.compare((Double)mergeCost.get(o1), (Double)mergeCost.get(o2)));
            mergeQs.set(winningQ, mergeQ_k);
            Branch n_k = merged;
            IntList owned_nk = new IntList();
            Iterator owned_nkz = n_k.iterator();
            while (owned_nkz.hasNext()) {
                int i5 = (Integer)owned_nkz.next();
                owned_nk.add(i5);
            }
            int size_k = owned_nk.size();
            for (int z = 0; z < anchor_nodes.size(); ++z) {
                Vec pivot_candidate;
                if (z == winningQ || anchor_nodes.get(z) == null) continue;
                Node n_z = (Node)anchor_nodes.get(z);
                Pair<Integer, Integer> p = winningQ < z ? new Pair<Integer, Integer>(winningQ, z) : new Pair<Integer, Integer>(z, winningQ);
                IntList owned_nkz2 = new IntList(owned_nk);
                iterator = n_z.iterator();
                while (iterator.hasNext()) {
                    int i6 = (Integer)iterator.next();
                    owned_nkz2.add(i6);
                }
                int size_nk = owned_nkz2.size();
                int size_z = size_nk - size_k;
                if (this.pivot_method == PivotSelection.CENTROID) {
                    pivot_candidate = n_k.pivot.clone();
                    pivot_candidate.mutableMultiply((double)size_k / (double)size_nk);
                    pivot_candidate.mutableAdd((double)size_z / (double)size_nk, n_z.pivot);
                } else {
                    pivot_candidate = this.pivot_method.getPivot(parallel, owned_nkz2, this.allVecs, this.dm, this.cache);
                }
                List<Double> pivor_candidate_qi = this.dm.getQueryInfo(pivot_candidate);
                double radius_kz = 0.0;
                Iterator iterator4 = owned_nkz2.iterator();
                while (iterator4.hasNext()) {
                    int i7 = (Integer)iterator4.next();
                    radius_kz = Math.max(radius_kz, this.dm.dist(i7, pivot_candidate, pivor_candidate_qi, this.allVecs, this.cache));
                }
                pivotCache.put(p, pivot_candidate);
                if (winningQ < z) {
                    mergeCost.put(p, radius_kz);
                    mergeQ_k.add(p);
                    continue;
                }
                ((PriorityQueue)mergeQs.get(z)).remove(p);
                mergeCost.put(p, radius_kz);
                ((PriorityQueue)mergeQs.get(z)).add(p);
            }
            if (mergeQ_k.isEmpty()) continue;
            QQ.add(winningQ);
        }
        return toReturn;
    }

    private Node build(List<Integer> points, boolean parallel) {
        if (points.size() <= this.leaf_size) {
            Leaf leaf = new Leaf(new IntList(points));
            leaf.setPivot(points);
            leaf.setRadius(points);
            return leaf;
        }
        switch (this.construction_method) {
            case ANCHORS_HIERARCHY: {
                return this.build_anchors(points, parallel);
            }
            case KD_STYLE: {
                return this.build_kd(points, parallel);
            }
            case TOP_DOWN_FARTHEST: {
                return this.build_far_top_down(points, parallel);
            }
        }
        return new Leaf(new IntList(0));
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.allVecs = new ArrayList<V>(collection);
        this.setDistanceMetric(dm);
        this.cache = dm.getAccelerationCache(this.allVecs, parallel);
        this.root = this.build(IntList.range(collection.size()), parallel);
    }

    @Override
    public void insert(V x) {
        if (this.root == null) {
            this.allVecs = new ArrayList<V>();
            this.allVecs.add(x);
            this.cache = this.dm.getAccelerationCache(this.allVecs);
            this.root = new Leaf(IntList.range(1));
            this.root.pivot = ((Vec)x).clone();
            this.root.pivot_qi = this.dm.getQueryInfo((Vec)x);
            this.root.radius = 0.0;
            return;
        }
        int indx = this.allVecs.size();
        this.allVecs.add(x);
        if (this.cache != null) {
            this.cache.addAll(this.dm.getQueryInfo((Vec)x));
        }
        Branch parentNode = null;
        Node curNode = this.root;
        double dist_to_curNode = this.dm.dist(indx, curNode.pivot, curNode.pivot_qi, this.allVecs, this.cache);
        while (curNode != null) {
            curNode.radius = Math.max(curNode.radius, dist_to_curNode);
            if (curNode instanceof Leaf) {
                Leaf lroot = (Leaf)curNode;
                lroot.children.add(indx);
                if (lroot.children.size() > this.leaf_size) {
                    Node newNode = this.build(lroot.children, false);
                    if (parentNode == null) {
                        this.root = newNode;
                    } else if (parentNode.left_child == curNode) {
                        parentNode.left_child = newNode;
                    } else {
                        parentNode.right_child = newNode;
                    }
                }
                return;
            }
            Branch b = (Branch)curNode;
            double left_dist = this.dm.dist(indx, b.left_child.pivot, b.left_child.pivot_qi, this.allVecs, this.cache);
            double right_dist = this.dm.dist(indx, b.right_child.pivot, b.right_child.pivot_qi, this.allVecs, this.cache);
            double left_rad_inc = b.left_child.radius - left_dist;
            double right_rad_inc = b.right_child.radius - right_dist;
            parentNode = b;
            if (left_rad_inc < right_rad_inc) {
                curNode = b.left_child;
                dist_to_curNode = left_dist;
                continue;
            }
            curNode = b.right_child;
            dist_to_curNode = right_dist;
        }
    }

    @Override
    public BallTree<V> clone() {
        return new BallTree<V>(this);
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        this.root.search(query, this.dm.getQueryInfo(query), range, neighbors, distances);
        IndexTable it = new IndexTable(distances);
        it.apply(distances);
        it.apply(neighbors);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        BoundedSortedList<IndexDistPair> knn = new BoundedSortedList<IndexDistPair>(numNeighbors);
        this.root.search(query, this.dm.getQueryInfo(query), numNeighbors, knn, Double.POSITIVE_INFINITY);
        for (IndexDistPair p : knn) {
            neighbors.add(p.indx);
            distances.add(p.dist);
        }
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.allVecs.get(indx));
    }

    @Override
    public int size() {
        return this.allVecs.size();
    }

    private Node cloneChangeContext(Node toClone) {
        if (toClone != null) {
            if (toClone instanceof Leaf) {
                return new Leaf((Leaf)toClone);
            }
            return new Branch((Branch)toClone);
        }
        return null;
    }

    private static /* synthetic */ IndexDistPair lambda$build_anchors$110(DoubleList[] ownedDist, int z) {
        return new IndexDistPair(z, ownedDist[z].get(ownedDist[z].size() - 1));
    }

    private /* synthetic */ IndexDistPair lambda$build_far_top_down$103(int f1, Integer i) {
        return new IndexDistPair(i, this.dm.dist((int)i, f1, this.allVecs, this.cache));
    }

    private /* synthetic */ IndexDistPair lambda$build_far_top_down$102(Branch branch, Integer i) {
        return new IndexDistPair(i, this.dm.dist(i, branch.pivot, branch.pivot_qi, this.allVecs, this.cache));
    }

    private class Branch
    extends Node {
        Node left_child;
        Node right_child;

        public Branch() {
        }

        public Branch(Branch toCopy) {
            super(toCopy);
            this.left_child = BallTree.this.cloneChangeContext(toCopy.left_child);
            this.right_child = BallTree.this.cloneChangeContext(toCopy.right_child);
        }

        @Override
        public void search(Vec query, List<Double> qi, double range, List<Integer> neighbors, List<Double> distances) {
            if (BallTree.this.dm.dist(query, this.pivot) - this.radius >= range) {
                return;
            }
            this.left_child.search(query, qi, range, neighbors, distances);
            this.right_child.search(query, qi, range, neighbors, distances);
        }

        @Override
        public void search(Vec query, List<Double> qi, int numNeighbors, BoundedSortedList<IndexDistPair> knn, double pivot_to_query) {
            if (Double.isInfinite(pivot_to_query)) {
                pivot_to_query = BallTree.this.dm.dist(query, this.pivot);
            }
            if (knn.size() >= numNeighbors && pivot_to_query - this.radius >= knn.last().dist) {
                return;
            }
            double dist_left = BallTree.this.dm.dist(query, this.left_child.pivot);
            double dist_right = BallTree.this.dm.dist(query, this.right_child.pivot);
            double close_child_dist = dist_left;
            Node close_child = this.left_child;
            double far_child_dist = dist_right;
            Node far_child = this.right_child;
            if (dist_right < dist_left) {
                close_child_dist = dist_right;
                close_child = this.right_child;
                far_child_dist = dist_left;
                far_child = this.left_child;
            }
            close_child.search(query, qi, numNeighbors, knn, close_child_dist);
            far_child.search(query, qi, numNeighbors, knn, far_child_dist);
        }

        @Override
        public Iterator<Integer> iterator() {
            final Iterator iter_left = this.left_child.iterator();
            if (this.right_child == null) {
                System.out.println("AWD?");
            }
            final Iterator iter_right = this.right_child.iterator();
            return new Iterator<Integer>(){

                @Override
                public boolean hasNext() {
                    return iter_left.hasNext() || iter_right.hasNext();
                }

                @Override
                public Integer next() {
                    if (iter_left.hasNext()) {
                        return (Integer)iter_left.next();
                    }
                    return (Integer)iter_right.next();
                }
            };
        }
    }

    private class Leaf
    extends Node {
        IntList children;

        public Leaf(IntList children) {
            this.children = children;
        }

        public Leaf(Leaf toCopy) {
            super(toCopy);
            this.children = new IntList(toCopy.children);
        }

        @Override
        public void search(Vec query, List<Double> qi, double range, List<Integer> neighbors, List<Double> distances) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                int indx = (Integer)iterator.next();
                double dist = BallTree.this.dm.dist(indx, query, qi, BallTree.this.allVecs, BallTree.this.cache);
                if (!(dist <= range)) continue;
                neighbors.add(indx);
                distances.add(dist);
            }
        }

        @Override
        public void search(Vec query, List<Double> qi, int numNeighbors, BoundedSortedList<IndexDistPair> knn, double pivot_to_query) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                int indx = (Integer)iterator.next();
                knn.add(new IndexDistPair(indx, BallTree.this.dm.dist(indx, query, qi, BallTree.this.allVecs, BallTree.this.cache)));
            }
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.children.iterator();
        }
    }

    private abstract class Node
    implements Cloneable,
    Serializable,
    Iterable<Integer> {
        Vec pivot;
        List<Double> pivot_qi;
        double radius;

        public Node() {
        }

        public Node(Node toCopy) {
            if (toCopy.pivot != null) {
                this.pivot = toCopy.pivot.clone();
            }
            if (toCopy.pivot_qi != null) {
                this.pivot_qi = new DoubleList(toCopy.pivot_qi);
            }
            this.radius = toCopy.radius;
        }

        public void setPivot(List<Integer> points) {
            this.pivot = points.size() == 1 ? ((Vec)BallTree.this.get(points.get(0))).clone() : BallTree.this.pivot_method.getPivot(false, points, BallTree.this.allVecs, BallTree.this.dm, BallTree.this.cache);
            this.pivot_qi = BallTree.this.dm.getQueryInfo(this.pivot);
        }

        public void setRadius(List<Integer> points) {
            this.radius = 0.0;
            for (int i : points) {
                this.radius = Math.max(this.radius, BallTree.this.dm.dist(i, this.pivot, this.pivot_qi, BallTree.this.allVecs, BallTree.this.cache));
            }
        }

        public abstract void search(Vec var1, List<Double> var2, double var3, List<Integer> var5, List<Double> var6);

        public abstract void search(Vec var1, List<Double> var2, int var3, BoundedSortedList<IndexDistPair> var4, double var5);
    }

    public static enum PivotSelection {
        CENTROID{

            @Override
            public Vec getPivot(boolean parallel, List<Integer> points, List<? extends Vec> data, DistanceMetric dm, List<Double> cache) {
                if (points.size() == 1) {
                    return data.get(points.get(0)).clone();
                }
                DenseVector pivot = new DenseVector(data.get(points.get(0)).length());
                for (int i : points) {
                    pivot.mutableAdd(data.get(i));
                }
                ((Vec)pivot).mutableDivide(points.size());
                return pivot;
            }
        }
        ,
        MEDOID{

            @Override
            public Vec getPivot(boolean parallel, List<Integer> points, List<? extends Vec> data, DistanceMetric dm, List<Double> cache) {
                if (points.size() == 1) {
                    return data.get(points.get(0)).clone();
                }
                int indx = dm.isValidMetric() ? TRIKMEDS.medoid(parallel, points, data, dm, cache) : PAM.medoid(parallel, points, data, dm, cache);
                return data.get(indx);
            }
        };


        public abstract Vec getPivot(boolean var1, List<Integer> var2, List<? extends Vec> var3, DistanceMetric var4, List<Double> var5);
    }

    public static enum ConstructionMethod {
        TOP_DOWN_FARTHEST,
        KD_STYLE,
        ANCHORS_HIERARCHY;

    }
}

