/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.CosineDistance;
import jsat.linear.distancemetrics.DistanceMetric;

public class CosineDistanceNormalized
implements DistanceMetric {
    private static final long serialVersionUID = -4041803247001806577L;

    @Override
    public double dist(Vec a, Vec b) {
        return CosineDistance.cosineToDistance(Math.min(a.dot(b), 1.0));
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSubadditive() {
        return true;
    }

    @Override
    public boolean isIndiscemible() {
        return true;
    }

    @Override
    public double metricBound() {
        return 1.0;
    }

    @Override
    public String toString() {
        return "Cosine Distance (Normalized)";
    }

    @Override
    public CosineDistanceNormalized clone() {
        return new CosineDistanceNormalized();
    }

    @Override
    public boolean supportsAcceleration() {
        return false;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs, boolean parallel) {
        return null;
    }

    @Override
    public double dist(int a, int b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), vecs.get(b));
    }

    @Override
    public double dist(int a, Vec b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), b);
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return null;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> vecs, ExecutorService threadpool) {
        return null;
    }

    @Override
    public double dist(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), b);
    }
}

