/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.empirical.kernelfunc;

import jsat.distributions.empirical.kernelfunc.KernelFunction;

public class UniformKF
implements KernelFunction {
    private static final long serialVersionUID = -6413579643511350896L;

    private UniformKF() {
    }

    public static UniformKF getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public double k(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return 0.5;
    }

    @Override
    public double intK(double u) {
        if (u < -1.0) {
            return 0.0;
        }
        if (u > 1.0) {
            return 1.0;
        }
        return (u + 1.0) / 2.0;
    }

    @Override
    public double k2() {
        return 0.3333333333333333;
    }

    @Override
    public double cutOff() {
        return Math.ulp(1.0f) + 1.0f;
    }

    @Override
    public double kPrime(double u) {
        return 0.0;
    }

    @Override
    public String toString() {
        return "Uniform Kernel";
    }

    private static class SingletonHolder {
        public static final UniformKF INSTANCE = new UniformKF();

        private SingletonHolder() {
        }
    }
}

