/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import java.util.Random;
import jsat.distributions.discrete.DiscreteDistribution;
import jsat.math.SpecialMath;

public class Poisson
extends DiscreteDistribution {
    private double lambda;

    public Poisson() {
        this(1.0);
    }

    public Poisson(double lambda) {
        this.setLambda(lambda);
    }

    public void setLambda(double lambda) {
        if (Double.isNaN(lambda) || lambda <= 0.0 || Double.isInfinite(lambda)) {
            throw new IllegalArgumentException("lambda must be positive, not " + lambda);
        }
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double logPmf(int x) {
        if (x < 0) {
            return -1.7976931348623157E308;
        }
        return -SpecialMath.lnGamma(x + 1) - this.lambda + (double)x * Math.log(this.lambda);
    }

    @Override
    public double pmf(int x) {
        if (x < 0) {
            return 0.0;
        }
        return Math.exp(this.logPmf(x));
    }

    @Override
    public double cdf(int x) {
        if (x < 0) {
            return 0.0;
        }
        return SpecialMath.gammaQ(x + 1, this.lambda);
    }

    private double sampleOne(Random rand) {
        double rhs;
        double v;
        double y;
        double lhs;
        double u;
        double x;
        double n;
        double c = 0.767 - 3.36 / this.lambda;
        double beta = Math.PI / Math.sqrt(3.0 * this.lambda);
        double alpha = beta * this.lambda;
        double k = Math.log(c) - this.lambda - Math.log(beta);
        while ((n = Math.floor((x = (alpha - Math.log((1.0 - (u = rand.nextDouble())) / u)) / beta) + 0.5)) < 0.0 || !((lhs = (y = alpha - beta * x) + Math.log(v = rand.nextDouble()) - 2.0 * Math.log(Math.exp(y) + 1.0)) <= (rhs = k + n * Math.log(this.lambda) - SpecialMath.lnGamma(n + 1.0)))) {
        }
        return n;
    }

    @Override
    public double[] sample(int numSamples, Random rand) {
        double[] samples = new double[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            samples[i] = this.sampleOne(rand);
        }
        return samples;
    }

    @Override
    public double mean() {
        return this.lambda;
    }

    @Override
    public double mode() {
        if (this.lambda < 1.0) {
            return 0.0;
        }
        if (this.lambda > 1.0 && Math.rint(this.lambda) != this.lambda) {
            return Math.floor(this.lambda);
        }
        return this.lambda;
    }

    @Override
    public double variance() {
        return this.lambda;
    }

    @Override
    public double skewness() {
        return 1.0 / this.standardDeviation();
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Poisson clone() {
        return new Poisson(this.lambda);
    }
}

