/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public class Uniform
extends ContinuousDistribution {
    private static final long serialVersionUID = 2479606544724378610L;
    private double a;
    private double b;

    public Uniform(double a, double b) {
        double min = Math.min(a, b);
        double max = Math.max(a, b);
        this.a = min;
        this.b = max;
    }

    @Override
    public double pdf(double x) {
        if (this.a == this.b && this.a == x) {
            return 0.0;
        }
        if (this.a <= x && x <= this.b) {
            return 1.0 / (this.b - this.a);
        }
        return 0.0;
    }

    @Override
    public double cdf(double x) {
        if (this.a > x) {
            return 0.0;
        }
        if (x >= this.b) {
            return 1.0;
        }
        if (this.a == this.b && this.a == x) {
            return 1.0;
        }
        return (x - this.a) / (this.b - this.a);
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Probability must be interface the range [0,1], not " + p);
        }
        if (this.a == this.b && p == 1.0) {
            return this.a;
        }
        return this.a + p * (this.b - this.a);
    }

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Uniform";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"a", "b"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.a, this.b};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("a")) {
            this.a = value;
        } else if (var.equals("b")) {
            this.b = value;
        }
        double min = Math.min(this.a, this.b);
        double max = Math.max(this.a, this.b);
        this.a = min;
        this.b = max;
    }

    @Override
    public ContinuousDistribution clone() {
        return new Uniform(this.a, this.b);
    }

    @Override
    public void setUsingData(Vec data) {
        this.a = data.min();
        this.b = data.max();
    }

    @Override
    public double mean() {
        return (this.a + this.b) * 0.5;
    }

    @Override
    public double median() {
        return this.mean();
    }

    @Override
    public double mode() {
        return this.mean();
    }

    @Override
    public double variance() {
        return Math.pow(this.b - this.a, 2.0) / 12.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uniform other = (Uniform)obj;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(other.a)) {
            return false;
        }
        return Double.doubleToLongBits(this.b) == Double.doubleToLongBits(other.b);
    }
}

