/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public class Pareto
extends ContinuousDistribution {
    private static final long serialVersionUID = 2055881279858330509L;
    private double xm;
    private double alpha;

    public Pareto() {
        this(1.0, 3.0);
    }

    public Pareto(double xm, double alpha) {
        this.setXm(xm);
        this.setAlpha(alpha);
    }

    public final void setAlpha(double alpha) {
        if (alpha <= 0.0) {
            throw new ArithmeticException("Shape parameter must be > 0, not " + alpha);
        }
        this.alpha = alpha;
    }

    public final void setXm(double xm) {
        if (xm <= 0.0) {
            throw new ArithmeticException("Scale parameter must be > 0, not " + xm);
        }
        this.xm = xm;
    }

    @Override
    public double logPdf(double x) {
        if (x < this.xm) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.alpha) + this.alpha * Math.log(this.xm) - (this.alpha + 1.0) * Math.log(x);
    }

    @Override
    public double pdf(double x) {
        if (x < this.xm) {
            return 0.0;
        }
        return Math.exp(this.logPdf(x));
    }

    @Override
    public double cdf(double x) {
        return 1.0 - Math.exp(this.alpha * Math.log(this.xm / x));
    }

    @Override
    public double invCdf(double p) {
        return this.xm * Math.pow(1.0 - p, -1.0 / this.alpha);
    }

    @Override
    public double min() {
        return this.xm;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Pareto";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"x_m", "\u03b1"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.xm, this.alpha};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("x_m")) {
            this.setXm(value);
        } else if (var.equals("\u03b1")) {
            this.setAlpha(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Pareto(this.xm, this.alpha);
    }

    @Override
    public void setUsingData(Vec data) {
        double mean = data.mean();
        double var = data.variance();
        double aP = Math.sqrt((mean * mean + var) / var);
        double alphaC = aP + 1.0;
        double xmC = mean * aP / alphaC;
        if (alphaC > 0.0 && xmC > 0.0) {
            this.setAlpha(alphaC);
            this.setXm(xmC);
        }
    }

    @Override
    public double mean() {
        if (this.alpha > 1.0) {
            return this.alpha * this.xm / (this.alpha - 1.0);
        }
        return Double.NaN;
    }

    @Override
    public double mode() {
        return this.xm;
    }

    @Override
    public double variance() {
        if (this.alpha > 2.0) {
            return this.xm * this.xm * this.alpha / (Math.pow(this.alpha - 1.0, 2.0) * (this.alpha - 2.0));
        }
        return Double.NaN;
    }

    @Override
    public double skewness() {
        return Math.sqrt((this.alpha - 2.0) / this.alpha) * (2.0 * (1.0 + this.alpha) / (this.alpha - 3.0));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.alpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.xm);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pareto other = (Pareto)obj;
        if (Double.doubleToLongBits(this.alpha) != Double.doubleToLongBits(other.alpha)) {
            return false;
        }
        return Double.doubleToLongBits(this.xm) == Double.doubleToLongBits(other.xm);
    }
}

