/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import jsat.classifiers.evaluation.SimpleBinaryClassMetric;

public class MatthewsCorrelationCoefficient
extends SimpleBinaryClassMetric {
    private static final long serialVersionUID = 7102318546460007008L;

    public MatthewsCorrelationCoefficient() {
    }

    public MatthewsCorrelationCoefficient(MatthewsCorrelationCoefficient toClone) {
        super(toClone);
    }

    @Override
    public double getScore() {
        double denom = (this.tp + this.fp) * (this.tp + this.fn) * (this.tn + this.fp) * (this.tn + this.fn);
        if (denom <= 1.0E-16) {
            return 0.0;
        }
        return (this.tp * this.tn - this.fp * this.fn) / Math.sqrt(denom);
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public MatthewsCorrelationCoefficient clone() {
        return new MatthewsCorrelationCoefficient(this);
    }

    @Override
    public String getName() {
        return "Matthews Correlation Coefficient";
    }
}

