/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import java.util.PriorityQueue;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.OneVSOne;

public class DDAG
extends OneVSOne {
    private static final long serialVersionUID = -9109002614319657144L;

    public DDAG(Classifier baseClassifier, boolean concurrentTrain) {
        super(baseClassifier, concurrentTrain);
    }

    public DDAG(Classifier baseClassifier) {
        super(baseClassifier);
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.predicting.getNumOfCategories());
        PriorityQueue<Integer> options = new PriorityQueue<Integer>(this.predicting.getNumOfCategories());
        for (int i = 0; i < cr.size(); ++i) {
            options.add(i);
        }
        while (options.size() > 1) {
            int c2;
            int c1 = (Integer)options.poll();
            CategoricalResults subRes = this.oneVone[c1][(c2 = ((Integer)options.poll()).intValue()) - c1 - 1].classify(data);
            if (subRes.mostLikely() == 0) {
                options.add(c1);
                continue;
            }
            options.add(c2);
        }
        cr.setProb((Integer)options.peek(), 1.0);
        return cr;
    }

    @Override
    public DDAG clone() {
        DDAG clone = new DDAG(this.baseClassifier.clone(), this.isConcurrentTraining());
        if (this.oneVone != null) {
            clone.oneVone = new Classifier[this.oneVone.length][];
            for (int i = 0; i < this.oneVone.length; ++i) {
                clone.oneVone[i] = new Classifier[this.oneVone[i].length];
                for (int j = 0; j < this.oneVone[i].length; ++j) {
                    clone.oneVone[i][j] = this.oneVone[i][j].clone();
                }
            }
        }
        if (this.predicting != null) {
            clone.predicting = this.predicting.clone();
        }
        return clone;
    }
}

