/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.regression.RegressionDataSet;

public class SimpleDataSet
extends DataSet<SimpleDataSet> {
    protected List<DataPoint> dataPoints;

    public SimpleDataSet(List<DataPoint> dataPoints) {
        if (dataPoints.isEmpty()) {
            throw new RuntimeException("Can not create empty data set");
        }
        this.dataPoints = dataPoints;
        this.categories = dataPoints.get(0).getCategoricalData();
        this.numNumerVals = dataPoints.get(0).numNumericalValues();
        this.numericalVariableNames = new ArrayList(this.numNumerVals);
        for (int i = 0; i < this.getNumNumericalVars(); ++i) {
            this.numericalVariableNames.add("Numeric Input " + (i + 1));
        }
    }

    public SimpleDataSet(CategoricalData[] categories, int numNumericalValues) {
        this.categories = categories;
        this.numNumerVals = numNumericalValues;
        this.dataPoints = new ArrayList<DataPoint>();
    }

    @Override
    public DataPoint getDataPoint(int i) {
        return this.dataPoints.get(i);
    }

    @Override
    public void setDataPoint(int i, DataPoint dp) {
        this.dataPoints.set(i, dp);
        this.columnVecCache.clear();
    }

    public void add(DataPoint dp) {
        this.dataPoints.add(dp);
        this.columnVecCache.clear();
    }

    @Override
    public int getSampleSize() {
        return this.dataPoints.size();
    }

    @Override
    protected SimpleDataSet getSubset(List<Integer> indicies) {
        SimpleDataSet newData = new SimpleDataSet(this.categories, this.numNumerVals);
        for (int i : indicies) {
            newData.add(this.getDataPoint(i));
        }
        return newData;
    }

    public ClassificationDataSet asClassificationDataSet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a non-negative value");
        }
        if (this.getNumCategoricalVars() == 0) {
            throw new IllegalArgumentException("Dataset has no categorical variables, can not create classification dataset");
        }
        if (index >= this.getNumCategoricalVars()) {
            throw new IllegalArgumentException("Index " + index + " is larger than number of categorical features " + this.getNumCategoricalVars());
        }
        return new ClassificationDataSet(this, index);
    }

    public RegressionDataSet asRegressionDataSet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a non-negative value");
        }
        if (this.getNumNumericalVars() == 0) {
            throw new IllegalArgumentException("Dataset has no numeric variables, can not create regression dataset");
        }
        if (index >= this.getNumNumericalVars()) {
            throw new IllegalArgumentException("Index " + index + " i larger than number of numeric features " + this.getNumNumericalVars());
        }
        return new RegressionDataSet(this.dataPoints, index);
    }

    public List<DataPoint> getBackingList() {
        return this.dataPoints;
    }

    public SimpleDataSet shallowClone() {
        return new SimpleDataSet(new ArrayList<DataPoint>(this.dataPoints));
    }

    @Override
    public SimpleDataSet getTwiceShallowClone() {
        return (SimpleDataSet)super.getTwiceShallowClone();
    }
}

