/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.micromanager.utils.ReportingUtils;

public class UIMonitor {
    private static AWTEventListener clickListener_ = null;

    private static String getComponentText(Component component) {
        if (component instanceof AbstractButton) {
            return ((AbstractButton)component).getText();
        }
        if (component instanceof Button) {
            return ((Button)component).getLabel();
        }
        return "";
    }

    private static String getComponentName(Component component) {
        String text = component.getName();
        if (text == null || text.isEmpty()) {
            text = UIMonitor.getComponentText(component);
        }
        return text;
    }

    private static String getClickAction(Component component) {
        if (component instanceof JToggleButton) {
            return "toggled " + (((JToggleButton)component).isSelected() ? "on" : "off");
        }
        if (component instanceof JCheckBoxMenuItem) {
            return "toggled " + (((JCheckBoxMenuItem)component).isSelected() ? "on" : "off");
        }
        if (component instanceof JList) {
            return null;
        }
        if (component instanceof JSlider) {
            return "set to \"" + ((JSlider)component).getValue() + "\"";
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            return "set to \"" + tabbedPane.getTitleAt(tabbedPane.getSelectedIndex()) + "\"";
        }
        return "clicked";
    }

    private static String getReleaseAction(Component component) {
        if (component instanceof JList) {
            try {
                JList list = (JList)component;
                return "set to \"" + list.getSelectedValue().toString() + "\"";
            }
            catch (NullPointerException npe) {
                ReportingUtils.logError("NullPOinterException in UIMonitor-getReleaseAction");
            }
        }
        return null;
    }

    private static void handleAWTEvent(AWTEvent event) {
        Object source;
        int eventID = event.getID();
        String identifier = null;
        String action = null;
        if (0L != ((long)eventID & 0x80L) && (source = event.getSource()) instanceof Component) {
            Component component = (Component)source;
            if (component.isEnabled()) {
                try {
                    String text = UIMonitor.getComponentName(component);
                    if (text != null && !text.isEmpty()) {
                        text = "\"" + text + "\" ";
                    }
                    identifier = source.getClass().getSimpleName() + " " + text;
                    if (eventID == 500) {
                        action = UIMonitor.getClickAction(component);
                    }
                    if (eventID == 502) {
                        action = UIMonitor.getReleaseAction(component);
                    }
                }
                catch (NullPointerException npe) {
                    ReportingUtils.logError("Null pointer Exception in UIMonitor-handleAWTEvent");
                }
            }
            if (identifier != null && action != null) {
                try {
                    String message = "[UI] " + identifier + action + " in " + ((Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)source)).getClass().getSimpleName() + ".";
                    ReportingUtils.logMessage(message);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    private static void enable() {
        if (clickListener_ != null) {
            return;
        }
        clickListener_ = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                UIMonitor.handleAWTEvent(event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(clickListener_, 16L);
    }

    private static void disable() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(clickListener_);
        clickListener_ = null;
    }

    public static void enable(final boolean on) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (on) {
                    UIMonitor.enable();
                } else {
                    UIMonitor.disable();
                }
            }
        });
    }
}

