/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.micromanager.ConfigGroupPad;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SliderPanel;
import org.micromanager.utils.StateItem;

public class StatePresetCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    StateItem stateItem_;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        JComponent comp;
        ConfigGroupPad.StateTableData data = (ConfigGroupPad.StateTableData)table.getModel();
        this.stateItem_ = data.getPropertyItem(rowIndex);
        if (this.stateItem_.hasLimits) {
            SliderPanel slider = new SliderPanel();
            if (this.stateItem_.isInteger()) {
                slider.setLimits((int)this.stateItem_.lowerLimit, (int)this.stateItem_.upperLimit);
            } else {
                slider.setLimits(this.stateItem_.lowerLimit, this.stateItem_.upperLimit);
            }
            try {
                slider.setText((String)value);
            }
            catch (ParseException ex) {
                ReportingUtils.logError(ex);
            }
            slider.setToolTipText((String)value);
            comp = slider;
        } else {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setFont(new Font("Arial", 0, 10));
            label.setText(this.stateItem_.config.toString());
            label.setToolTipText(this.stateItem_.descr);
            label.setHorizontalAlignment(2);
            comp = label;
        }
        if (isSelected) {
            ((Component)comp).setBackground(Color.LIGHT_GRAY);
        } else {
            ((Component)comp).setBackground(Color.WHITE);
        }
        return comp;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

