/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.micromanager.ConfigGroupPad;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SliderPanel;
import org.micromanager.utils.SortFunctionObjects;
import org.micromanager.utils.StateItem;

public class StatePresetCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    JTextField text_ = new JTextField();
    JComboBox combo_ = new JComboBox();
    StateItem item_;
    SliderPanel slider_ = new SliderPanel();

    public StatePresetCellEditor() {
        this.slider_.addEditActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatePresetCellEditor.this.fireEditingStopped();
            }
        });
        this.slider_.addSliderMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                StatePresetCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        if (isSelected) {
            // empty if block
        }
        ConfigGroupPad.StateTableData data = (ConfigGroupPad.StateTableData)table.getModel();
        this.item_ = data.getPropertyItem(rowIndex);
        if (this.item_.allowed.length == 0) {
            this.text_.setText((String)value);
            return this.text_;
        }
        if (this.item_.allowed.length == 1 && this.item_.singleProp) {
            if (this.item_.hasLimits) {
                if (this.item_.isInteger()) {
                    this.slider_.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                } else {
                    this.slider_.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                }
                try {
                    this.slider_.setText((String)value);
                }
                catch (ParseException ex) {
                    ReportingUtils.logError(ex);
                }
                return this.slider_;
            }
            if (this.item_.singlePropAllowed != null && this.item_.singlePropAllowed.length > 0) {
                this.setComboBox(this.item_.allowed);
                return this.combo_;
            }
            this.text_.setText((String)value);
            return this.text_;
        }
        if (1 < this.item_.allowed.length) {
            boolean allNumeric2 = true;
            for (int k = 0; k < this.item_.allowed.length; ++k) {
                if (this.item_.allowed[k].length() <= 0 || Character.isDigit(this.item_.allowed[k].charAt(0))) continue;
                allNumeric2 = false;
                break;
            }
            if (allNumeric2) {
                Arrays.sort(this.item_.allowed, new SortFunctionObjects.NumericPrefixStringComp());
            } else {
                Arrays.sort(this.item_.allowed);
            }
        }
        this.setComboBox(this.item_.allowed);
        return this.combo_;
    }

    private void setComboBox(String[] allowed) {
        int i;
        ActionListener[] l = this.combo_.getActionListeners();
        for (i = 0; i < l.length; ++i) {
            this.combo_.removeActionListener(l[i]);
        }
        this.combo_.removeAllItems();
        for (i = 0; i < allowed.length; ++i) {
            this.combo_.addItem(allowed[i]);
        }
        this.combo_.removeAllItems();
        for (i = 0; i < allowed.length; ++i) {
            this.combo_.addItem(allowed[i]);
        }
        this.combo_.setSelectedItem(this.item_.config);
        this.combo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatePresetCellEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (this.item_.allowed.length == 1) {
            if (this.item_.singleProp && this.item_.hasLimits) {
                return this.slider_.getText();
            }
            if (this.item_.singlePropAllowed != null && this.item_.singlePropAllowed.length == 0) {
                return this.text_.getText();
            }
            return this.combo_.getSelectedItem();
        }
        return this.combo_.getSelectedItem();
    }
}

