/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.text.ParseException;
import java.util.Comparator;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class SortFunctionObjects {

    public static class NumericPrefixStringComp
    implements Comparator<String> {
        private int NumericPrefix(String str0) {
            int ii;
            int ret = 0;
            for (ii = 0; ii < str0.length() && Character.isDigit(str0.charAt(ii)); ++ii) {
            }
            if (0 < ii) {
                ret = Integer.valueOf(str0.substring(0, ii));
            }
            return ret;
        }

        @Override
        public int compare(String strA, String strB) {
            return this.NumericPrefix(strA) - this.NumericPrefix(strB);
        }
    }

    public static class DoubleStringComp
    implements Comparator<String> {
        @Override
        public int compare(String strA, String strB) {
            double valA = 0.0;
            double valB = 0.0;
            try {
                valA = NumberUtils.coreStringToDouble(strA);
                valB = NumberUtils.coreStringToDouble(strB);
            }
            catch (ParseException e) {
                ReportingUtils.logError(e);
            }
            return Double.compare(valA, valB);
        }
    }

    public static class IntStringComp
    implements Comparator<String> {
        @Override
        public int compare(String strA, String strB) {
            int valA = 0;
            int valB = 0;
            try {
                valA = NumberUtils.coreStringToInt(strA);
                valB = NumberUtils.coreStringToInt(strB);
            }
            catch (ParseException e) {
                ReportingUtils.logError(e);
            }
            return valA - valB;
        }
    }
}

