/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class SliderPanel
extends JPanel {
    private static final long serialVersionUID = -6039226355990936685L;
    private SpringLayout springLayout_ = new SpringLayout();
    private JTextField textField_;
    private double lowerLimit_ = 0.0;
    private double upperLimit_ = 10.0;
    private final int STEPS = 1000;
    private double factor_ = 1.0;
    private boolean integer_ = false;
    private ChangeListener sliderChangeListener_;
    private JScrollBar slider_;

    public SliderPanel() {
        this.setLayout(this.springLayout_);
        this.setPreferredSize(new Dimension(304, 18));
        this.textField_ = new JTextField();
        this.textField_.setFont(new Font("", 0, 10));
        this.textField_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SliderPanel.this.onEditChange();
            }
        });
        this.add(this.textField_);
        this.springLayout_.putConstraint("East", (Component)this.textField_, 40, "West", (Component)this);
        this.springLayout_.putConstraint("West", (Component)this.textField_, 0, "West", (Component)this);
        this.springLayout_.putConstraint("South", (Component)this.textField_, 0, "South", (Component)this);
        this.springLayout_.putConstraint("North", (Component)this.textField_, 0, "North", (Component)this);
        this.sliderChangeListener_ = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SliderPanel.this.onSliderMove();
            }
        };
        this.slider_ = new JScrollBar(0);
        this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
        this.add(this.slider_);
        this.springLayout_.putConstraint("East", (Component)this.slider_, 0, "East", (Component)this);
        this.springLayout_.putConstraint("West", (Component)this.slider_, 41, "West", (Component)this);
        this.springLayout_.putConstraint("South", (Component)this.slider_, 0, "South", (Component)this);
        this.springLayout_.putConstraint("North", (Component)this.slider_, 0, "North", (Component)this);
    }

    public String getText() {
        try {
            this.setText(this.textField_.getText());
        }
        catch (ParseException ex) {
            ReportingUtils.logError("Asked to convert an empty variable into a number in SliderPanel.java.  This indicates a faulty Device Adapter.");
        }
        return this.textField_.getText();
    }

    public void enableEdit(boolean state) {
        this.textField_.setEditable(state);
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        this.integer_ = false;
        this.factor_ = (upperLimit - lowerLimit) / 1000.0;
        this.upperLimit_ = upperLimit;
        this.lowerLimit_ = lowerLimit;
        this.slider_.setMinimum(0);
        this.slider_.setMaximum(1000);
        this.slider_.setVisibleAmount(0);
    }

    public void setLimits(int lowerLimit, int upperLimit) {
        this.integer_ = true;
        this.upperLimit_ = upperLimit;
        this.lowerLimit_ = lowerLimit;
        this.slider_.setMinimum(0);
        this.factor_ = 1.0;
        int maximum = upperLimit - lowerLimit + 1;
        if (upperLimit > 1000) {
            this.factor_ = ((double)upperLimit - (double)lowerLimit) / 1000.0;
            maximum = 1001;
        }
        this.slider_.setMaximum(maximum);
        this.slider_.setVisibleAmount(1);
    }

    private void setSliderValue(double val) {
        this.slider_.setValue((int)Math.round((val - this.lowerLimit_) / this.factor_));
    }

    private void onSliderMove() {
        double value = (double)this.slider_.getValue() * this.factor_ + this.lowerLimit_;
        if (this.integer_) {
            this.textField_.setText(NumberUtils.intToDisplayString((int)value));
        } else {
            this.textField_.setText(NumberUtils.doubleToDisplayString(value));
        }
    }

    protected void onEditChange() {
        try {
            double val = this.enforceLimits(NumberUtils.displayStringToDouble(this.textField_.getText()));
            this.slider_.getModel().removeChangeListener(this.sliderChangeListener_);
            this.setSliderValue(val);
            this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
        }
        catch (ParseException p) {
            this.handleException(p);
        }
    }

    public void setText(String txt) throws ParseException {
        double val;
        if (this.integer_) {
            val = this.enforceLimits(NumberUtils.displayStringToInt(txt));
            this.textField_.setText(NumberUtils.intToDisplayString((int)val));
        } else {
            val = this.enforceLimits(NumberUtils.displayStringToDouble(txt));
            this.textField_.setText(NumberUtils.doubleToDisplayString(val));
        }
        this.slider_.getModel().removeChangeListener(this.sliderChangeListener_);
        this.setSliderValue(val);
        this.slider_.getModel().addChangeListener(this.sliderChangeListener_);
    }

    private double enforceLimits(double value) {
        double val = value;
        if (val < this.lowerLimit_) {
            val = this.lowerLimit_;
        }
        if (val > this.upperLimit_) {
            val = this.upperLimit_;
        }
        return val;
    }

    private int enforceLimits(int value) {
        int val = value;
        if ((double)val < this.lowerLimit_) {
            val = (int)this.lowerLimit_;
        }
        if ((double)val > this.upperLimit_) {
            val = (int)this.upperLimit_;
        }
        return val;
    }

    public void addEditActionListener(ActionListener al) {
        this.textField_.addActionListener(al);
    }

    public void addSliderMouseListener(MouseAdapter md) {
        JScrollBar comp;
        this.slider_.addMouseListener(md);
        if (JavaUtils.isWindows() && (comp = this.slider_) instanceof Container) {
            Container cm = comp;
            for (int i = 0; i < cm.getComponentCount(); ++i) {
                Component cont = cm.getComponent(i);
                if (!(cont instanceof JButton)) continue;
                cont.addMouseListener(md);
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.slider_ != null) {
            this.slider_.setBackground(bg);
        }
        if (this.textField_ != null) {
            this.textField_.setBackground(bg);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField_.setEnabled(enabled);
        this.slider_.setEnabled(enabled);
    }

    private void handleException(Exception e) {
        ReportingUtils.showError(e);
    }
}

