/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.DeviceType;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;

public class ShowFlagsPanel
extends JLayeredPane {
    private static final long serialVersionUID = 2414705031299832388L;
    private JCheckBox showCamerasCheckBox_;
    private JCheckBox showShuttersCheckBox_;
    private JCheckBox showStagesCheckBox_;
    private JCheckBox showStateDevicesCheckBox_;
    private JCheckBox showOtherCheckBox_;
    private Configuration initialCfg_;
    private ShowFlags flags_;
    private PropertyTableData data_;
    private CMMCore core_;

    public ShowFlagsPanel(PropertyTableData data, ShowFlags flags, CMMCore core, Configuration initialCfg) {
        this.data_ = data;
        this.flags_ = flags;
        this.core_ = core;
        this.initialCfg_ = initialCfg;
        this.setBorder(BorderFactory.createTitledBorder("Show"));
        this.createCheckboxes();
        this.initializeCheckboxes();
    }

    public void createCheckboxes() {
        this.showCamerasCheckBox_ = new JCheckBox();
        this.showCamerasCheckBox_.setFont(new Font("", 0, 10));
        this.showCamerasCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ShowFlagsPanel)ShowFlagsPanel.this).flags_.cameras_ = ShowFlagsPanel.this.showCamerasCheckBox_.isSelected();
                ShowFlagsPanel.this.data_.updateRowVisibility(ShowFlagsPanel.this.flags_);
            }
        });
        this.showCamerasCheckBox_.setText("cameras");
        this.add(this.showCamerasCheckBox_);
        this.showCamerasCheckBox_.setBounds(5, 20, 130, 20);
        this.showShuttersCheckBox_ = new JCheckBox();
        this.showShuttersCheckBox_.setFont(new Font("", 0, 10));
        this.showShuttersCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ShowFlagsPanel)ShowFlagsPanel.this).flags_.shutters_ = ShowFlagsPanel.this.showShuttersCheckBox_.isSelected();
                ShowFlagsPanel.this.data_.updateRowVisibility(ShowFlagsPanel.this.flags_);
            }
        });
        this.showShuttersCheckBox_.setText("shutters");
        this.add(this.showShuttersCheckBox_);
        this.showShuttersCheckBox_.setBounds(5, 40, 130, 20);
        this.showStagesCheckBox_ = new JCheckBox();
        this.showStagesCheckBox_.setFont(new Font("", 0, 10));
        this.showStagesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ShowFlagsPanel)ShowFlagsPanel.this).flags_.stages_ = ShowFlagsPanel.this.showStagesCheckBox_.isSelected();
                ShowFlagsPanel.this.data_.updateRowVisibility(ShowFlagsPanel.this.flags_);
            }
        });
        this.showStagesCheckBox_.setText("stages");
        this.add(this.showStagesCheckBox_);
        this.showStagesCheckBox_.setBounds(5, 60, 130, 20);
        this.showStateDevicesCheckBox_ = new JCheckBox();
        this.showStateDevicesCheckBox_.setFont(new Font("", 0, 10));
        this.showStateDevicesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ShowFlagsPanel)ShowFlagsPanel.this).flags_.state_ = ShowFlagsPanel.this.showStateDevicesCheckBox_.isSelected();
                ShowFlagsPanel.this.data_.updateRowVisibility(ShowFlagsPanel.this.flags_);
            }
        });
        this.showStateDevicesCheckBox_.setText("wheels, turrets, etc.");
        this.add(this.showStateDevicesCheckBox_);
        this.showStateDevicesCheckBox_.setBounds(5, 80, 130, 20);
        this.showOtherCheckBox_ = new JCheckBox();
        this.showOtherCheckBox_.setFont(new Font("", 0, 10));
        this.showOtherCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((ShowFlagsPanel)ShowFlagsPanel.this).flags_.other_ = ShowFlagsPanel.this.showOtherCheckBox_.isSelected();
                ShowFlagsPanel.this.data_.updateRowVisibility(ShowFlagsPanel.this.flags_);
            }
        });
        this.showOtherCheckBox_.setText("other devices");
        this.add(this.showOtherCheckBox_);
        this.showOtherCheckBox_.setBounds(5, 100, 130, 20);
    }

    protected void initializeCheckboxes() {
        try {
            this.showCamerasCheckBox_.setSelected(this.flags_.cameras_);
            this.showStagesCheckBox_.setSelected(this.flags_.stages_);
            this.showShuttersCheckBox_.setSelected(this.flags_.shutters_);
            this.showStateDevicesCheckBox_.setSelected(this.flags_.state_);
            this.showOtherCheckBox_.setSelected(this.flags_.other_);
            int i = 0;
            while ((long)i < this.initialCfg_.size()) {
                DeviceType dtype = this.core_.getDeviceType(this.initialCfg_.getSetting((long)i).getDeviceLabel());
                if (dtype == DeviceType.CameraDevice) {
                    this.flags_.cameras_ = true;
                    this.showCamerasCheckBox_.setSelected(true);
                } else if (dtype == DeviceType.ShutterDevice) {
                    this.flags_.shutters_ = true;
                    this.showShuttersCheckBox_.setSelected(true);
                } else if (dtype == DeviceType.StageDevice) {
                    this.flags_.stages_ = true;
                    this.showStagesCheckBox_.setSelected(true);
                } else if (dtype == DeviceType.StateDevice) {
                    this.flags_.state_ = true;
                    this.showStateDevicesCheckBox_.setSelected(true);
                } else {
                    this.showOtherCheckBox_.setSelected(true);
                    this.flags_.other_ = true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) {
        ReportingUtils.logError(e);
    }
}

