/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mmcorej.CMMCore;
import org.micromanager.MMStudio;

public class ReportingUtils {
    private static CMMCore core_ = null;
    private static JFrame owningFrame_;
    private static boolean show_;

    public static void SetContainingFrame(JFrame f) {
        owningFrame_ = f;
    }

    public static void setCore(CMMCore core) {
        core_ = core;
    }

    public static void showErrorOn(boolean show) {
        show_ = show;
    }

    public static void logMessage(String msg) {
        if (core_ == null) {
            System.out.println(msg);
        } else {
            core_.logMessage(msg);
        }
    }

    public static void logDebugMessage(String msg) {
        if (core_ == null) {
            System.out.println(msg);
        } else {
            core_.logMessage(msg, true);
        }
    }

    public static void showMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg);
    }

    public static void showMessage(String msg, Component parent) {
        JOptionPane.showMessageDialog(parent, msg);
    }

    public static void logError(Throwable e, String msg) {
        if (e != null) {
            String stackTrace = ReportingUtils.getStackTraceAsString(e);
            ReportingUtils.logMessage(msg + "\n" + e.toString() + " in " + Thread.currentThread().toString() + "\n" + stackTrace + "\n");
        } else {
            ReportingUtils.logMessage("Error: " + msg);
        }
    }

    public static void logError(Throwable e) {
        ReportingUtils.logError(e, "");
    }

    public static void logError(String msg) {
        ReportingUtils.logError(null, msg);
    }

    public static void showError(Throwable e, String msg, Component parent) {
        ReportingUtils.logError(e, msg);
        if (!show_) {
            return;
        }
        String fullMsg = e != null && e.getMessage() != null && msg.length() > 0 ? "Error: " + msg + "\n" + e.getMessage() : (e != null && e.getMessage() != null ? e.getMessage() : (msg.length() > 0 ? "Error: " + msg : (e != null ? "Error: " + e.getStackTrace()[0] : "Unknown error (please check CoreLog.txt file for more information)")));
        ReportingUtils.showErrorMessage(fullMsg, parent);
    }

    private static String formatAlertMessage(String[] lines) {
        Escaper escaper = HtmlEscapers.htmlEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (String line : lines) {
            sb.append("<div width='640'>");
            sb.append(escaper.escape(line));
            sb.append("</div>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static void showErrorMessage(String fullMsg, Component parent) {
        int maxNrLines = 10;
        String[] lines = fullMsg.split("\n");
        if (lines.length < maxNrLines) {
            String wrappedMsg = ReportingUtils.formatAlertMessage(lines);
            JOptionPane.showMessageDialog(parent, wrappedMsg, "Micro-Manager Error", 0);
        } else {
            JTextArea area = new JTextArea(fullMsg);
            area.setRows(maxNrLines);
            area.setColumns(50);
            area.setLineWrap(true);
            JScrollPane pane = new JScrollPane(area);
            JOptionPane.showMessageDialog(parent, pane, "Micro-Manager Error", 0);
        }
    }

    public static void showError(Throwable e) {
        ReportingUtils.showError(e, "", MMStudio.getFrame());
    }

    public static void showError(String msg) {
        ReportingUtils.showError(null, msg, MMStudio.getFrame());
    }

    public static void showError(Throwable e, String msg) {
        ReportingUtils.showError(e, msg, MMStudio.getFrame());
    }

    public static void showError(Throwable e, Component parent) {
        ReportingUtils.showError(e, "", parent);
    }

    public static void showError(String msg, Component parent) {
        ReportingUtils.showError(null, msg, parent);
    }

    private static String getStackTraceAsString(Throwable aThrowable) {
        String result = "";
        for (StackTraceElement line : aThrowable.getStackTrace()) {
            result = result + "  at " + line.toString() + "\n";
        }
        Throwable cause = aThrowable.getCause();
        if (cause != null) {
            return result + "Caused by: " + cause.toString() + "\n" + ReportingUtils.getStackTraceAsString(cause);
        }
        return result;
    }

    public static String getStackTraceAsString() {
        String result = "";
        for (StackTraceElement line : Thread.currentThread().getStackTrace()) {
            result = result + "  at " + line.toString() + "\n";
        }
        return result;
    }

    public static String getCaller() {
        return Thread.currentThread().getStackTrace()[3].toString();
    }

    public static void showError(ActionEvent e) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void displayNonBlockingMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReportingUtils.displayNonBlockingMessage(message);
                }
            });
            return;
        }
        if (null != owningFrame_) {
            Calendar c = Calendar.getInstance();
            final JOptionPane optionPane = new JOptionPane(c.getTime().toString() + " " + message, 2, 2);
            final JDialog dialog = new JDialog(owningFrame_, "\u03bcManager Warning: ", false);
            optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                        dialog.setVisible(false);
                    }
                }
            });
            dialog.setContentPane(optionPane);
            dialog.pack();
            dialog.setLocationRelativeTo(owningFrame_);
            dialog.setVisible(true);
        }
    }

    static {
        show_ = true;
    }
}

