/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SliderPanel;

public class PropertyValueCellRenderer
implements TableCellRenderer {
    PropertyItem item_;
    JLabel lab_ = new JLabel();
    private boolean disable_;

    public PropertyValueCellRenderer(boolean disable) {
        this.disable_ = disable;
    }

    public PropertyValueCellRenderer() {
        this(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        JComponent comp;
        MMPropertyTableModel data = (MMPropertyTableModel)((Object)table.getModel());
        this.item_ = data.getPropertyItem(rowIndex);
        this.lab_.setOpaque(true);
        this.lab_.setHorizontalAlignment(2);
        if (this.item_.hasRange) {
            SliderPanel slider = new SliderPanel();
            if (this.item_.isInteger()) {
                slider.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
            } else {
                slider.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
            }
            try {
                slider.setText((String)value);
            }
            catch (ParseException ex) {
                ReportingUtils.logError(ex);
            }
            slider.setToolTipText(this.item_.value);
            comp = slider;
        } else {
            this.lab_.setText(this.item_.value);
            comp = this.lab_;
        }
        if (this.disable_) {
            ((Component)comp).setEnabled(false);
        }
        if (this.item_.readOnly) {
            ((Component)comp).setBackground(Color.LIGHT_GRAY);
        } else {
            ((Component)comp).setBackground(Color.WHITE);
        }
        return comp;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

