/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.DeviceType;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;

public class PropertyTableData
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = -5582899855072387637L;
    int PropertyNameColumn_;
    protected int PropertyValueColumn_;
    int PropertyUsedColumn_;
    public boolean disabled = false;
    public String groupName_;
    public String presetName_;
    public ShowFlags flags_;
    public ScriptInterface gui_;
    public boolean showUnused_;
    protected boolean showReadOnly_;
    String[] columnNames_ = new String[3];
    public ArrayList<PropertyItem> propList_ = new ArrayList();
    public ArrayList<PropertyItem> propListVisible_ = new ArrayList();
    protected CMMCore core_ = null;
    Configuration[] groupData_;
    PropertySetting[] groupSignature_;
    private String[] presetNames_;
    private volatile boolean updating_;
    private boolean groupOnly_;

    public PropertyTableData(CMMCore core, String groupName, String presetName, int PropertyValueColumn, int PropertyUsedColumn, boolean groupOnly) {
        this.core_ = core;
        this.groupName_ = groupName;
        this.presetName_ = presetName;
        this.PropertyNameColumn_ = 0;
        this.PropertyValueColumn_ = PropertyValueColumn;
        this.PropertyUsedColumn_ = PropertyUsedColumn;
        this.groupOnly_ = groupOnly;
    }

    public ArrayList<PropertyItem> getProperties() {
        return this.propList_;
    }

    public String findMatchingPreset() {
        ArrayList<PropertyItem> selectedItems = new ArrayList<PropertyItem>();
        for (PropertyItem item : this.propList_) {
            if (!item.confInclude) continue;
            selectedItems.add(item);
        }
        for (int i = 0; i < this.groupData_.length; ++i) {
            int matchCount = 0;
            for (PropertyItem selectedItem : selectedItems) {
                PropertySetting ps = new PropertySetting(selectedItem.device, selectedItem.name, selectedItem.value);
                if (!this.groupData_[i].isSettingIncluded(ps)) continue;
                ++matchCount;
            }
            if (matchCount != selectedItems.size()) continue;
            return this.presetNames_[i];
        }
        return null;
    }

    public PropertyItem getItem(String device, String propName) {
        for (PropertyItem item : this.propList_) {
            if (!item.device.contentEquals(device) || !item.name.contentEquals(propName)) continue;
            return item;
        }
        return null;
    }

    public boolean verifyPresetSignature() {
        return true;
    }

    public void deleteConfig(String group, String config) {
        try {
            this.core_.deleteConfig(group, config);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public StrVector getAvailableConfigGroups() {
        return this.core_.getAvailableConfigGroups();
    }

    @Override
    public int getRowCount() {
        return this.propListVisible_.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames_.length;
    }

    public boolean isEditingGroup() {
        return true;
    }

    @Override
    public PropertyItem getPropertyItem(int row) {
        return this.propListVisible_.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        PropertyItem item = this.propListVisible_.get(row);
        if (col == this.PropertyNameColumn_) {
            return item.device + "-" + item.name;
        }
        if (col == this.PropertyValueColumn_) {
            return item.value;
        }
        if (col == this.PropertyUsedColumn_) {
            return item.confInclude;
        }
        return null;
    }

    public void setValueInCore(PropertyItem item, Object value) {
        ReportingUtils.logMessage(item.device + "/" + item.name + ":" + value);
        try {
            if (item.isInteger()) {
                this.core_.setProperty(item.device, item.name, NumberUtils.intStringDisplayToCore(value));
            } else if (item.isFloat()) {
                this.core_.setProperty(item.device, item.name, NumberUtils.doubleStringDisplayToCore(value));
            } else {
                this.core_.setProperty(item.device, item.name, value.toString());
            }
            item.value = value.toString();
            this.core_.waitForDevice(item.device);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PropertyItem item = this.propListVisible_.get(row);
        ReportingUtils.logMessage("Setting value " + value + " at row " + row);
        if (col == this.PropertyValueColumn_) {
            if (item.confInclude) {
                this.setValueInCore(item, value);
                this.core_.updateSystemStateCache();
                this.refresh(true);
                this.gui_.refreshGUIFromCache();
            }
        } else if (col == this.PropertyUsedColumn_) {
            item.confInclude = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames_[column];
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        if (nCol == this.PropertyValueColumn_) {
            if (nCol == 2) {
                return false;
            }
            return !this.propListVisible_.get((int)nRow).readOnly;
        }
        if (nCol == this.PropertyUsedColumn_) {
            return this.isEditingGroup();
        }
        return false;
    }

    StrVector getAvailableConfigs(String group) {
        return this.core_.getAvailableConfigs(group);
    }

    public void refresh(boolean fromCache) {
        try {
            this.update(fromCache);
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void update(boolean fromCache) {
        this.update(this.flags_, this.groupName_, this.presetName_, fromCache);
    }

    public void setShowReadOnly(boolean showReadOnly) {
        this.showReadOnly_ = showReadOnly;
    }

    public void update(ShowFlags flags, String groupName, String presetName, boolean fromCache) {
        try {
            StrVector devices = this.core_.getLoadedDevices();
            this.propList_.clear();
            Configuration cfg = this.core_.getConfigGroupState(groupName);
            boolean liveMode = this.gui_.isLiveModeOn();
            this.gui_.enableLiveMode(false);
            this.setUpdating(true);
            int i = 0;
            while ((long)i < devices.size()) {
                if (this.showDevice(flags, devices.get(i)).booleanValue()) {
                    StrVector properties = this.core_.getDevicePropertyNames(devices.get(i));
                    int j = 0;
                    while ((long)j < properties.size()) {
                        PropertyItem item = new PropertyItem();
                        if (!this.groupOnly_ || cfg.isPropertyIncluded(devices.get(i), properties.get(j))) {
                            item.readFromCore(this.core_, devices.get(i), properties.get(j), false);
                            if (!(item.readOnly && !this.showReadOnly_ || item.preInit)) {
                                if (cfg.isPropertyIncluded(item.device, item.name)) {
                                    item.confInclude = true;
                                    item.setValueFromCoreString(cfg.getSetting(item.device, item.name).getPropertyValue());
                                } else {
                                    item.confInclude = false;
                                    item.setValueFromCoreString(this.core_.getProperty(devices.get(i), properties.get(j)));
                                }
                                this.propList_.add(item);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.setUpdating(false);
            this.updateRowVisibility(flags);
            this.gui_.enableLiveMode(liveMode);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.fireTableStructureChanged();
    }

    public void updateRowVisibility(ShowFlags flags) {
        this.propListVisible_.clear();
        for (PropertyItem item : this.propList_) {
            boolean showDevice = this.showDevice(flags, item.device);
            if (!this.showUnused_ && !item.confInclude) {
                showDevice = false;
            }
            if (!showDevice) continue;
            this.propListVisible_.add(item);
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public Boolean showDevice(ShowFlags flags, String deviceName) {
        DeviceType dType = null;
        try {
            dType = this.core_.getDeviceType(deviceName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Boolean showDevice = false;
        showDevice = dType == DeviceType.SerialDevice ? Boolean.valueOf(false) : (dType == DeviceType.CameraDevice ? Boolean.valueOf(flags.cameras_) : (dType == DeviceType.ShutterDevice ? Boolean.valueOf(flags.shutters_) : (dType == DeviceType.StageDevice ? Boolean.valueOf(flags.stages_) : (dType == DeviceType.XYStageDevice ? Boolean.valueOf(flags.stages_) : (dType == DeviceType.StateDevice ? Boolean.valueOf(flags.state_) : Boolean.valueOf(flags.other_))))));
        return showDevice;
    }

    public void setColumnNames(String col0, String col1, String col2) {
        this.columnNames_[0] = col0;
        this.columnNames_[1] = col1;
        this.columnNames_[2] = col2;
    }

    private void handleException(Exception e) {
        ReportingUtils.showError(e);
    }

    public void setGUI(ScriptInterface gui) {
        this.gui_ = gui;
    }

    public void setFlags(ShowFlags flags) {
        this.flags_ = flags;
    }

    public void setShowUnused(boolean showUnused) {
        this.showUnused_ = showUnused;
    }

    public ArrayList<PropertyItem> getPropList() {
        return this.propList_;
    }

    public void setUpdating(boolean updating) {
        this.updating_ = updating;
    }

    public boolean updating() {
        return this.updating_;
    }
}

