/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.Arrays;
import mmcorej.CMMCore;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SortFunctionObjects;

public class PropertyItem {
    public String device;
    public String name;
    public String value;
    public boolean readOnly = false;
    public boolean preInit = false;
    public String[] allowed;
    public boolean confInclude = false;
    public boolean hasRange = false;
    public double lowerLimit = 0.0;
    public double upperLimit = 0.0;
    public PropertyType type;

    public PropertyItem() {
        this.device = new String();
        this.name = "Undefined";
        this.value = new String();
        this.allowed = new String[0];
    }

    public PropertyItem(String _name, String _value) {
        this.name = _name;
        this.value = _value;
        this.allowed = new String[0];
    }

    public PropertyItem(String _name, String _value, boolean _preInit) {
        this.name = _name;
        this.value = _value;
        this.allowed = new String[0];
        this.preInit = _preInit;
    }

    public void dump() {
        ReportingUtils.logMessage("Property : " + this.name);
        ReportingUtils.logMessage("Property : " + this.value);
        ReportingUtils.logMessage("   allowed :");
        for (int i = 0; i < this.allowed.length; ++i) {
            ReportingUtils.logMessage("   " + this.allowed[i]);
        }
    }

    public void setValueFromCoreString(String coreValue) {
        try {
            this.value = this.isInteger() ? NumberUtils.intStringCoreToDisplay(coreValue) : (this.isFloat() ? NumberUtils.doubleStringCoreToDisplay(coreValue) : coreValue);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            this.value = coreValue;
        }
    }

    public String getValueInCoreFormat() {
        try {
            if (this.isInteger()) {
                return NumberUtils.intStringDisplayToCore(this.value);
            }
            if (this.isFloat()) {
                return NumberUtils.doubleStringDisplayToCore(this.value);
            }
            return this.value;
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return this.value;
        }
    }

    public void readFromCore(CMMCore core, String deviceName, String propertyName, boolean cached) {
        this.device = deviceName;
        this.name = propertyName;
        try {
            this.readOnly = core.isPropertyReadOnly(deviceName, propertyName);
            this.preInit = core.isPropertyPreInit(deviceName, propertyName);
            this.hasRange = core.hasPropertyLimits(deviceName, propertyName);
            this.lowerLimit = core.getPropertyLowerLimit(deviceName, propertyName);
            this.upperLimit = core.getPropertyUpperLimit(deviceName, propertyName);
            this.type = core.getPropertyType(deviceName, propertyName);
            StrVector values = core.getAllowedPropertyValues(deviceName, propertyName);
            this.allowed = new String[(int)values.size()];
            int k = 0;
            while ((long)k < values.size()) {
                this.allowed[k] = values.get(k);
                ++k;
            }
            this.sort();
            String coreVal = cached ? core.getPropertyFromCache(deviceName, propertyName) : core.getProperty(deviceName, propertyName);
            this.setValueFromCoreString(coreVal);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
    }

    public void sort() {
        try {
            if (this.allowed.length > 0) {
                if (PropertyType.Float == this.type) {
                    Arrays.sort(this.allowed, new SortFunctionObjects.DoubleStringComp());
                } else if (PropertyType.Integer == this.type) {
                    Arrays.sort(this.allowed, new SortFunctionObjects.IntStringComp());
                } else if (PropertyType.String == this.type) {
                    boolean allNumeric = true;
                    for (int k = 0; k < this.allowed.length; ++k) {
                        if (null != this.allowed[k]) {
                            if (0 < this.allowed[k].length()) {
                                if (Character.isDigit(this.allowed[k].charAt(0))) continue;
                                allNumeric = false;
                                break;
                            }
                            allNumeric = false;
                            break;
                        }
                        allNumeric = false;
                        break;
                    }
                    if (allNumeric) {
                        Arrays.sort(this.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                    }
                }
            }
        }
        catch (Exception e) {
            ReportingUtils.logMessage("error sorting " + this.device + "." + this.name);
        }
    }

    public boolean isInteger() {
        return this.type == PropertyType.Integer;
    }

    public boolean isFloat() {
        return this.type == PropertyType.Float;
    }

    public boolean isString() {
        return this.type == PropertyType.String;
    }

    public boolean isUndefined() {
        return this.type == PropertyType.Undef;
    }
}

