/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberUtils {
    private static final NumberFormat format_ = NumberFormat.getInstance();
    private static final DecimalFormat coreDoubleFormat_;
    private static final DecimalFormat coreIntegerFormat_;

    public static String intToDisplayString(int number) {
        return format_.format(number);
    }

    public static String longToDisplayString(long number) {
        return format_.format(number);
    }

    public static String doubleToDisplayString(double number) {
        return format_.format(number);
    }

    public static int displayStringToInt(Object numberString) throws ParseException {
        return format_.parse((String)numberString).intValue();
    }

    public static long displayStringToLong(Object numberString) throws ParseException {
        return format_.parse((String)numberString).longValue();
    }

    public static double displayStringToDouble(Object numberString) throws ParseException {
        return format_.parse((String)numberString).doubleValue();
    }

    public static String intToCoreString(long number) {
        return coreIntegerFormat_.format(number);
    }

    public static String longToCoreString(long number) {
        return coreIntegerFormat_.format(number);
    }

    public static String doubleToCoreString(double number) {
        return coreDoubleFormat_.format(number);
    }

    public static int coreStringToInt(Object numberString) throws ParseException {
        return coreIntegerFormat_.parse((String)numberString).intValue();
    }

    public static long coreStringToLong(Object numberString) throws ParseException {
        return coreIntegerFormat_.parse((String)numberString).longValue();
    }

    public static double coreStringToDouble(Object numberString) throws ParseException {
        return coreDoubleFormat_.parse((String)numberString).doubleValue();
    }

    public static String doubleStringDisplayToCore(Object numberDouble) throws ParseException {
        return NumberUtils.doubleToCoreString(NumberUtils.displayStringToDouble(numberDouble));
    }

    public static String doubleStringCoreToDisplay(Object numberDouble) throws ParseException {
        return NumberUtils.doubleToDisplayString(NumberUtils.coreStringToDouble(numberDouble));
    }

    public static String intStringDisplayToCore(Object numberInt) throws ParseException {
        return NumberUtils.intToCoreString(NumberUtils.displayStringToInt(numberInt));
    }

    public static String intStringCoreToDisplay(Object numberInt) throws ParseException {
        return NumberUtils.intToDisplayString(NumberUtils.coreStringToInt(numberInt));
    }

    static {
        format_.setRoundingMode(RoundingMode.HALF_UP);
        format_.setMaximumFractionDigits(4);
        coreDoubleFormat_ = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        coreDoubleFormat_.setRoundingMode(RoundingMode.HALF_UP);
        coreDoubleFormat_.applyPattern("0.0000");
        coreIntegerFormat_ = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        coreIntegerFormat_.applyPattern("0");
    }
}

