/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;

public class MathFunctions {
    private static void insertPoint2DInMatrix(RealMatrix m, Point2D.Double pt, int row) {
        m.setEntry(row, 0, pt.x);
        m.setEntry(row, 1, pt.y);
        m.setEntry(row, 2, 1.0);
    }

    public static AffineTransform generateAffineTransformFromPointPairs(Map<Point2D.Double, Point2D.Double> pointPairs) {
        Array2DRowRealMatrix u = new Array2DRowRealMatrix(pointPairs.size(), 3);
        Array2DRowRealMatrix v = new Array2DRowRealMatrix(pointPairs.size(), 3);
        int i = 0;
        for (Map.Entry<Point2D.Double, Point2D.Double> pair : pointPairs.entrySet()) {
            Point2D.Double uPt = pair.getKey();
            Point2D.Double vPt = pair.getValue();
            MathFunctions.insertPoint2DInMatrix((RealMatrix)u, uPt, i);
            MathFunctions.insertPoint2DInMatrix((RealMatrix)v, vPt, i);
            ++i;
        }
        DecompositionSolver solver = new QRDecompositionImpl((RealMatrix)u).getSolver();
        double[][] m = solver.solve((RealMatrix)v).transpose().getData();
        return new AffineTransform(m[0][0], m[1][0], m[0][1], m[1][1], m[0][2], m[1][2]);
    }

    public static AffineTransform generateAffineTransformFromPointPairs(Map<Point2D.Double, Point2D.Double> pointPairs, double srcTol, double destTol) throws Exception {
        AffineTransform transform = MathFunctions.generateAffineTransformFromPointPairs(pointPairs);
        double srcDevSqSum = 0.0;
        double destDevSqSum = 0.0;
        for (Map.Entry<Point2D.Double, Point2D.Double> pair : pointPairs.entrySet()) {
            try {
                Point2D.Double srcPt = pair.getKey();
                Point2D.Double destPt = pair.getValue();
                Point2D.Double srcPt2 = (Point2D.Double)transform.inverseTransform(destPt, null);
                Point2D.Double destPt2 = (Point2D.Double)transform.transform(srcPt, null);
                srcDevSqSum += srcPt.distanceSq(srcPt2);
                destDevSqSum += destPt.distanceSq(destPt2);
            }
            catch (NoninvertibleTransformException ex) {
                throw new Exception("Singular matrix encountered.");
            }
        }
        int n = pointPairs.size();
        double srcRMS = Math.sqrt(srcDevSqSum / (double)n);
        double destRMS = Math.sqrt(destDevSqSum / (double)n);
        if (srcRMS > srcTol || destRMS > destTol) {
            throw new Exception("Point mapping scatter exceeds tolerance.");
        }
        return transform;
    }

    public static double getScalingFactor(AffineTransform transform) {
        return Math.sqrt(Math.abs(transform.getDeterminant()));
    }

    public static double clip(double min, double val, double max) {
        return Math.min(Math.max(min, val), max);
    }

    public static int clip(int min, int val, int max) {
        return Math.min(Math.max(min, val), max);
    }

    public static void runAffineTest() {
        HashMap<Point2D.Double, Point2D.Double> pointPairs = new HashMap<Point2D.Double, Point2D.Double>();
        pointPairs.put(new Point2D.Double(1.0, 1.0), new Point2D.Double(18.0, 2.0));
        pointPairs.put(new Point2D.Double(1.0, 9.0), new Point2D.Double(2.0, 2.0));
        pointPairs.put(new Point2D.Double(9.0, 9.0), new Point2D.Double(2.0, 18.0));
        pointPairs.put(new Point2D.Double(9.0, 1.0), new Point2D.Double(18.0, 18.0));
        AffineTransform affineTransform = MathFunctions.generateAffineTransformFromPointPairs(pointPairs);
        System.out.println(pointPairs);
        System.out.println(affineTransform);
        int i = 0;
        for (Map.Entry pair : pointPairs.entrySet()) {
            Point2D.Double uPt = (Point2D.Double)pair.getKey();
            Point2D.Double vPt = (Point2D.Double)pair.getValue();
            Point2D.Double result = new Point2D.Double();
            affineTransform.transform(uPt, result);
            System.out.println(uPt + "->" + result + " residual: " + vPt.distance(result));
            ++i;
        }
    }
}

