/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MMUUEncoder {
    protected int maxBytesPerLine = 45;

    public void encodeBuffer(InputStream in, OutputStream out) throws IOException {
        out.write("begin 664 raw.bin\n".getBytes());
        byte[] buffer = new byte[this.maxBytesPerLine * 4 / 3];
        int counter = 0;
        while (true) {
            int value1;
            if (counter == this.maxBytesPerLine * 4 / 3) {
                MMUUEncoder.writeWithLength(out, buffer, counter);
                counter = 0;
            }
            if ((value1 = in.read()) < 0) break;
            int value2 = in.read();
            int value3 = in.read();
            int packed = (value1 & 0xFF) << 16 | (value2 & 0xFF) << 8 | value3 & 0xFF;
            buffer[counter++] = MMUUEncoder.encode(packed >> 18 & 0x3F);
            buffer[counter++] = MMUUEncoder.encode(packed >> 12 & 0x3F);
            if (value2 < 0) break;
            buffer[counter++] = MMUUEncoder.encode(packed >> 6 & 0x3F);
            if (value3 < 0) break;
            buffer[counter++] = MMUUEncoder.encode(packed & 0x3F);
        }
        if (counter > 0) {
            MMUUEncoder.writeWithLength(out, buffer, counter);
        }
        out.write("`\nend\n".getBytes());
    }

    public static void writeWithLength(OutputStream out, byte[] buffer, int counter) throws IOException {
        out.write(MMUUEncoder.encode(counter * 3 / 4));
        out.write(buffer, 0, counter);
        out.write(10);
    }

    public static byte encode(int value) {
        return (byte)(value == 0 ? 96 : 32 + value);
    }
}

