/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import java.awt.Font;
import java.text.NumberFormat;

public class MMScaleBar {
    private Position pos_ = Position.TOPLEFT;
    private final int OFFSET = 10;
    private ImagePlus ip_;
    private Font font_ = new Font("Helvetics", 0, 12);
    private double pixelSizeUm_;
    private final double MULTIPLIER = Math.sqrt(10.0);
    private int exponent_ = 0;
    private int barWidth_;
    private int barHeight_;
    private String value_;
    private String units_ = "\u00b5m";

    public MMScaleBar(ImagePlus ip) {
        this.ip_ = ip;
        double pixelSize = ip.getCalibration().pixelWidth;
        this.units_ = ip.getCalibration().getXUnit();
        if (pixelSize > 0.0) {
            double pixsPerUnit;
            int width = this.ip_.getWidth();
            int height = this.ip_.getHeight();
            this.barHeight_ = height / 75;
            int minBarWidth = width / 20;
            int maxBarWidth = width / 4;
            double pixs = pixsPerUnit = 1.0 / pixelSize;
            while (pixs < (double)minBarWidth) {
                pixs *= this.MULTIPLIER;
                ++this.exponent_;
            }
            while (pixs > (double)maxBarWidth) {
                pixs /= this.MULTIPLIER;
                --this.exponent_;
            }
            double value = Math.pow(this.MULTIPLIER, this.exponent_);
            NumberFormat format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(1);
            if (value > 10.0) {
                format.setMaximumFractionDigits(0);
            }
            this.value_ = format.format(value);
            this.barWidth_ = (int)pixs;
        }
    }

    public void setPosition(Position pos) {
        this.pos_ = pos;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public static void removeScaleBarFromOverlay(Overlay ol) {
        int textIndex = -1;
        int barIndex = -1;
        for (int i = 0; i < ol.size(); ++i) {
            if (ol.get(i) instanceof MMText) {
                textIndex = i;
                continue;
            }
            if (!(ol.get(i) instanceof MMBar)) continue;
            barIndex = i;
        }
        if (textIndex != -1 && barIndex != -1) {
            ol.remove(barIndex);
            ol.remove(textIndex);
        }
    }

    public void addToOverlay(Overlay ol) {
        this.font_ = this.font_.deriveFont((int)(0.015 * (double)this.ip_.getWidth()));
        MMText text = new MMText(10, 10, this.value_ + this.units_, this.font_);
        int textWidth = this.ip_.getProcessor().getStringWidth(this.value_ + this.units_);
        if (this.pos_ == Position.TOPLEFT) {
            text.setLocation((int)(10.0 + 0.5 * (double)this.barWidth_ - 0.5 * (double)textWidth), 10 - this.barHeight_ - 2);
        } else if (this.pos_ == Position.TOPRIGHT) {
            text.setLocation((int)((double)(this.ip_.getWidth() - 10) - 0.5 * (double)this.barWidth_ - 0.5 * (double)textWidth), 10 - this.barHeight_ - 2);
        } else if (this.pos_ == Position.BOTTOMLEFT) {
            text.setLocation((int)(10.0 + 0.5 * (double)this.barWidth_ - 0.5 * (double)textWidth), this.ip_.getHeight() - 10 - 3 * this.barHeight_ - 2);
        } else if (this.pos_ == Position.BOTTOMRIGHT) {
            text.setLocation((int)((double)(this.ip_.getWidth() - 10) - 0.5 * (double)this.barWidth_ - 0.5 * (double)textWidth), this.ip_.getHeight() - 10 - 3 * this.barHeight_ - 2);
        }
        ol.add((Roi)text);
        MMBar bar = new MMBar(10, 10 + this.barHeight_, this.barWidth_, this.barHeight_);
        if (this.pos_ == Position.TOPRIGHT) {
            bar.setLocation(this.ip_.getWidth() - 10 - this.barWidth_, 10 + this.barHeight_);
        } else if (this.pos_ == Position.BOTTOMLEFT) {
            bar.setLocation(10, this.ip_.getHeight() - 10 - this.barHeight_);
        } else if (this.pos_ == Position.BOTTOMRIGHT) {
            bar.setLocation(this.ip_.getWidth() - 10 - this.barWidth_, this.ip_.getHeight() - 10 - this.barHeight_);
        }
        ol.add((Roi)bar);
    }

    private class MMText
    extends TextRoi {
        public MMText(int a, int b, String text, Font font) {
            super(a, b, text, font);
        }
    }

    private class MMBar
    extends Roi {
        public MMBar(int a, int b, int c, int d) {
            super(a, b, c, d);
        }
    }

    public static enum Position {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMRIGHT;

    }
}

