/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.KeyEventDispatcher;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.ReportingUtils;

public class MMKeyDispatcher
implements KeyEventDispatcher {
    Class textCanvasClass = null;
    final Class[] forbiddenClasses_;

    public MMKeyDispatcher() {
        try {
            this.textCanvasClass = ClassLoader.getSystemClassLoader().loadClass("ij.text.TextCanvas");
        }
        catch (ClassNotFoundException ex) {
            this.textCanvasClass = null;
            ReportingUtils.logError(ex);
        }
        Class[] forbiddenClasses = new Class[]{TextComponent.class, JTextComponent.class, RSyntaxTextArea.class, this.textCanvasClass};
        this.forbiddenClasses_ = forbiddenClasses;
    }

    private boolean checkSource(KeyEvent ke) {
        Object source = ke.getSource();
        for (Class clazz : this.forbiddenClasses_) {
            if (clazz == null || !clazz.isInstance(source)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ke) {
        if (!HotKeys.active_) {
            return false;
        }
        if (ke.getID() != 401) {
            return false;
        }
        if (HotKeys.keys_.containsKey(ke.getKeyCode()) && this.checkSource(ke)) {
            return HotKeys.keys_.get(ke.getKeyCode()).ExecuteAction();
        }
        return false;
    }
}

