/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.micromanager.MMStudio;
import org.micromanager.utils.GUIUtils;

public class MMFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Preferences prefs_;
    private final String prefPrefix_;
    private static final String WINDOW_X = "frame_x";
    private static final String WINDOW_Y = "frame_y";
    private static final String WINDOW_WIDTH = "frame_width";
    private static final String WINDOW_HEIGHT = "frame_height";

    public MMFrame() {
        this.finishConstructor();
        this.prefPrefix_ = "";
    }

    public MMFrame(String prefPrefix) {
        this.finishConstructor();
        this.prefPrefix_ = prefPrefix;
    }

    private void finishConstructor() {
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        MMStudio mfr = MMStudio.getInstance();
        if (mfr != null) {
            mfr.addMMBackgroundListener(this);
            this.setBackground(mfr.getBackgroundColor());
        }
    }

    private void ensureSafeWindowPosition(int x, int y) {
        int prefY;
        int prefX = this.prefs_.getInt(this.prefPrefix_ + WINDOW_X, 0);
        if (GUIUtils.getGraphicsConfigurationContaining(prefX, prefY = this.prefs_.getInt(this.prefPrefix_ + WINDOW_Y, 0)) == null) {
            this.prefs_.putInt(this.prefPrefix_ + WINDOW_X, x);
            this.prefs_.putInt(this.prefPrefix_ + WINDOW_Y, y);
        }
    }

    public void loadPosition(int x, int y, int width, int height) {
        if (this.prefs_ == null) {
            return;
        }
        this.ensureSafeWindowPosition(x, y);
        this.setBounds(this.prefs_.getInt(this.prefPrefix_ + WINDOW_X, x), this.prefs_.getInt(this.prefPrefix_ + WINDOW_Y, y), this.prefs_.getInt(this.prefPrefix_ + WINDOW_WIDTH, width), this.prefs_.getInt(this.prefPrefix_ + WINDOW_HEIGHT, height));
    }

    public void loadPosition(int x, int y) {
        if (this.prefs_ == null) {
            return;
        }
        this.ensureSafeWindowPosition(x, y);
        this.setBounds(this.prefs_.getInt(this.prefPrefix_ + WINDOW_X, x), this.prefs_.getInt(this.prefPrefix_ + WINDOW_Y, y), this.getWidth(), this.getHeight());
    }

    protected void loadAndRestorePosition(int x, int y, int width, int height) {
        this.loadPosition(x, y, width, height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MMFrame.this.savePosition();
            }
        });
    }

    protected void loadAndRestorePosition(int x, int y) {
        this.loadPosition(x, y);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MMFrame.this.savePosition();
            }
        });
    }

    public void savePosition() {
        if (this.prefs_ == null) {
            return;
        }
        Rectangle r = this.getBounds();
        this.prefs_.putInt(this.prefPrefix_ + WINDOW_X, r.x);
        this.prefs_.putInt(this.prefPrefix_ + WINDOW_Y, r.y);
        this.prefs_.putInt(this.prefPrefix_ + WINDOW_WIDTH, r.width);
        this.prefs_.putInt(this.prefPrefix_ + WINDOW_HEIGHT, r.height);
    }

    @Override
    public void dispose() {
        this.savePosition();
        super.dispose();
    }

    public Preferences getPrefsNode() {
        return this.prefs_;
    }

    public void setPrefsNode(Preferences prefs) {
        this.prefs_ = prefs;
    }
}

