/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import org.micromanager.MMStudio;
import org.micromanager.utils.GUIUtils;

public class MMDialog
extends JDialog {
    private static final long serialVersionUID = -3144618980027203294L;
    private Preferences mmDialogPrefs_;
    private final String prefPrefix_;
    private static final String WINDOW_X = "mmdlg_y";
    private static final String WINDOW_Y = "mmdlg_x";
    private static final String WINDOW_WIDTH = "mmdlg_width";
    private static final String WINDOW_HEIGHT = "mmdlg_height";

    public MMDialog() {
        this.finishConstructor();
        this.prefPrefix_ = "";
    }

    public MMDialog(String prefPrefix) {
        this.finishConstructor();
        this.prefPrefix_ = prefPrefix;
    }

    public MMDialog(Frame owner) {
        super(owner);
        this.finishConstructor();
        this.prefPrefix_ = "";
    }

    public MMDialog(Frame owner, boolean isModal) {
        super(owner, isModal);
        this.finishConstructor();
        this.prefPrefix_ = "";
    }

    private void finishConstructor() {
        this.mmDialogPrefs_ = Preferences.userNodeForPackage(this.getClass());
        MMStudio mfr = MMStudio.getInstance();
        if (mfr != null) {
            mfr.addMMBackgroundListener(this);
            this.setBackground(mfr.getBackgroundColor());
        }
    }

    private void ensureSafeWindowPosition(int x, int y) {
        int prefY;
        int prefX = this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_X, 0);
        if (GUIUtils.getGraphicsConfigurationContaining(prefX, prefY = this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_Y, 0)) == null) {
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_X, x);
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_Y, y);
        }
    }

    protected void loadAndRestorePosition(int x, int y, int width, int height) {
        this.loadPosition(x, y, width, height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MMDialog.this.savePosition();
            }
        });
    }

    protected void loadAndRestorePosition(int x, int y) {
        this.loadPosition(x, y);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MMDialog.this.savePosition();
            }
        });
    }

    protected void loadPosition(int x, int y, int width, int height) {
        this.ensureSafeWindowPosition(x, y);
        this.setBounds(this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_X, x), this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_Y, y), this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_WIDTH, width), this.mmDialogPrefs_.getInt(this.prefPrefix_ + WINDOW_HEIGHT, height));
    }

    @Override
    public void dispose() {
        this.savePosition();
        super.dispose();
    }

    protected void loadPosition(int x, int y) {
        this.ensureSafeWindowPosition(x, y);
        this.setLocation(this.mmDialogPrefs_.getInt(WINDOW_X, x), this.mmDialogPrefs_.getInt(WINDOW_Y, y));
    }

    protected void savePosition() {
        Rectangle r = this.getBounds();
        if (r != null) {
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_X, r.x);
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_Y, r.y);
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_WIDTH, r.width);
            this.mmDialogPrefs_.putInt(this.prefPrefix_ + WINDOW_HEIGHT, r.height);
        }
    }

    public Preferences getPrefsNode() {
        return this.mmDialogPrefs_;
    }

    public void setPrefsNode(Preferences p) {
        this.mmDialogPrefs_ = p;
    }
}

