/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.micromanager.utils.ReportingUtils;

public class JavaUtils {
    private static final String BACKING_STORE_AVAIL = "BackingStoreAvail";
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static List<Class<?>> findAndLoadClasses(File directory, int recursionLevel) {
        File[] files;
        URL directoryURL;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        try {
            directoryURL = directory.toURI().toURL();
        }
        catch (MalformedURLException e) {
            ReportingUtils.logError(e, "Failed to search for classes");
            return classes;
        }
        try {
            JavaUtils.addURL(directoryURL);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (File file : files = directory.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory() && recursionLevel > 0) {
                classes.addAll(JavaUtils.findAndLoadClasses(file, recursionLevel - 1));
                continue;
            }
            if (fileName.endsWith(".class")) {
                String className = JavaUtils.stripFilenameExtension(fileName);
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    ReportingUtils.logError(e, "Failed to load class: " + className + " (expected in " + fileName + ")");
                }
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            try {
                JavaUtils.addURL(new URL("jar:file:" + file.getAbsolutePath() + "!/"));
                JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
                JarEntry jarEntry = jarFile.getNextJarEntry();
                while (jarEntry != null) {
                    String classFileName = jarEntry.getName();
                    if (classFileName.endsWith(".class")) {
                        String className = JavaUtils.stripFilenameExtension(classFileName).replace("/", ".");
                        try {
                            classes.add(Class.forName(className));
                        }
                        catch (ClassNotFoundException e) {
                            ReportingUtils.logError(e, "Failed to load class: " + className + " (expected in " + file.getAbsolutePath() + " based on JAR entry");
                        }
                        catch (NoClassDefFoundError ncfe) {
                            ReportingUtils.logError(ncfe, "Failed to load class: " + className + " (expected in " + file.getAbsolutePath() + " based on JAR entry");
                        }
                    }
                    jarEntry = jarFile.getNextJarEntry();
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        return classes;
    }

    private static String stripFilenameExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(0, i);
        }
        return filename;
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader loader = (URLClassLoader)JavaUtils.class.getClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)loader, u);
            ReportingUtils.logMessage("Added URL to system class loader: " + u);
        }
        catch (Throwable t) {
            ReportingUtils.logError(t, "Failed to add URL to system class loader: " + u);
            throw new IOException("Failed to add URL to system class loader: " + u);
        }
    }

    public static Object invokeRestrictedMethod(Object obj, Class theClass, String methodName) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return JavaUtils.invokeRestrictedMethod(obj, theClass, methodName, new Object[]{null});
    }

    public static Object invokeRestrictedMethod(Object obj, Class theClass, String methodName, Object ... paramsAndTypes) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] paramTypes;
        Object[] params;
        int l;
        if (paramsAndTypes != null) {
            l = paramsAndTypes.length;
            params = new Object[l / 2];
            paramTypes = new Class[l / 2];
        } else {
            l = 0;
            params = null;
            paramTypes = null;
        }
        for (int i = 0; i < l / 2; ++i) {
            params[i] = paramsAndTypes[i * 2];
            paramTypes[i] = (Class)paramsAndTypes[i * 2 + 1];
        }
        return JavaUtils.invokeRestrictedMethod(obj, theClass, methodName, params, paramTypes);
    }

    public static Object invokeRestrictedMethod(Object obj, Class<?> theClass, String methodName, Object[] params, Class[] paramTypes) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = theClass.getDeclaredMethod(methodName, paramTypes);
        boolean wasAccessible = method.isAccessible();
        method.setAccessible(true);
        Object result = params == null ? method.invoke(obj, new Object[0]) : method.invoke(obj, params);
        method.setAccessible(wasAccessible);
        return result;
    }

    public static Object getRestrictedFieldValue(Object obj, Class theClass, String fieldName) throws NoSuchFieldException {
        Field field = theClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    public static void setRestrictedFieldValue(Object obj, Class theClass, String fieldName, Object value) throws NoSuchFieldException {
        Field field = theClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            ReportingUtils.logError(ex);
        }
    }

    public static boolean backingStoreAvailable(Preferences prefs) {
        try {
            boolean oldValue = prefs.getBoolean(BACKING_STORE_AVAIL, false);
            prefs.putBoolean(BACKING_STORE_AVAIL, !oldValue);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public static void putObjectInPrefs(Preferences prefs, String key, Serializable obj) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(obj);
        }
        catch (Exception e) {
            ReportingUtils.logError(e, "Failed to save object in Preferences.");
            return;
        }
        int MAX_LENGTH = 6144;
        byte[] serialBytes = byteStream.toByteArray();
        int totalLength = serialBytes.length;
        long nChunks = (int)Math.ceil((double)serialBytes.length / (double)MAX_LENGTH);
        try {
            if (prefs.nodeExists(key)) {
                prefs.node(key).removeNode();
            }
        }
        catch (BackingStoreException ex) {
            ReportingUtils.logError(ex);
        }
        int i = 0;
        while ((long)i < nChunks) {
            int chunkLength = Math.min(MAX_LENGTH, totalLength - i * MAX_LENGTH);
            byte[] chunk = new byte[chunkLength];
            System.arraycopy(serialBytes, i * MAX_LENGTH, chunk, 0, chunkLength);
            prefs.node(key).putByteArray(String.format("%09d", i), chunk);
            ++i;
        }
    }

    public static <T> T getObjectFromPrefs(Preferences prefs, String key, T def) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        byte[] serialBytes = new byte[]{};
        int totalLength = 0;
        try {
            for (String chunkKey : prefs.node(key).keys()) {
                byte[] chunk = prefs.node(key).getByteArray(chunkKey, new byte[0]);
                chunks.add(chunk);
                totalLength += chunk.length;
            }
            int pos = 0;
            serialBytes = new byte[totalLength];
            for (byte[] chunk : chunks) {
                System.arraycopy(chunk, 0, serialBytes, pos, chunk.length);
                pos += chunk.length;
            }
        }
        catch (BackingStoreException ex) {
            ReportingUtils.logError(ex);
        }
        if (serialBytes.length == 0) {
            return def;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serialBytes);
        try {
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            return (T)objectStream.readObject();
        }
        catch (Exception e) {
            ReportingUtils.logError(e, "Failed to get object from preferences.");
            return def;
        }
    }

    public static Dimension getScreenDimensions() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle bounds = gs[0].getDefaultConfiguration().getBounds();
        return new Dimension(bounds.width, bounds.height);
    }

    public static File createDirectory(String dirPath) throws Exception {
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new Exception("Unable to create directory " + dirPath);
        }
        return dir;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static void sleep(int time_ms) {
        try {
            Thread.sleep(time_ms);
        }
        catch (InterruptedException ex) {
            ReportingUtils.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String filepath, String text) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filepath));
            writer.write(text);
        }
        catch (IOException ex) {
            ReportingUtils.logError(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ReportingUtils.logError(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filepath) {
        File f = new File(filepath);
        if (!f.exists()) {
            return null;
        }
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(filepath));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ReportingUtils.logError(ex);
        }
        return contents.toString();
    }

    public static long getAvailableUnusedMemory() {
        Runtime r = Runtime.getRuntime();
        return r.maxMemory() - r.totalMemory() + r.freeMemory();
    }

    public static <T> T[] copyOfRange(T[] original, int start, int end) {
        if (original.length >= start && 0 <= start) {
            if (start <= end) {
                int length = end - start;
                int copyLength = Math.min(length, original.length - start);
                Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), length);
                System.arraycopy(original, start, copy, 0, copyLength);
                return copy;
            }
            throw new IllegalArgumentException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static String getApplicationDataPath() {
        if (JavaUtils.isMac()) {
            return System.getenv("HOME") + "/Library/Application Support/Micro-Manager/";
        }
        if (JavaUtils.isWindows()) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("xp")) {
                return System.getenv("APPDATA") + "/Micro-Manager/";
            }
            return System.getenv("LOCALAPPDATA") + "/Micro-Manager/";
        }
        if (JavaUtils.isUnix()) {
            return System.getenv("HOME") + "/.config/Micro-Manager/";
        }
        return null;
    }

    public static void printAllStackTraces() {
        System.err.println("\n\nDumping all stack traces:");
        Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
        for (Thread key : liveThreads.keySet()) {
            System.err.println("Thread " + key.getName());
            StackTraceElement[] trace = liveThreads.get(key);
            for (int j = 0; j < trace.length; ++j) {
                System.err.println("\tat " + trace[j]);
            }
        }
        System.err.println("End all stack traces. =============");
    }
}

