/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Point;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

public class ImageUtils {
    private static Class<?> storageClass_ = TaggedImageStorageDiskDefault.class;

    public static int BppToImageType(long Bpp) {
        int BppInt = (int)Bpp;
        switch (BppInt) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    public static int getImageProcessorType(ImageProcessor proc) {
        if (proc instanceof ByteProcessor) {
            return 0;
        }
        if (proc instanceof ShortProcessor) {
            return 1;
        }
        if (proc instanceof ColorProcessor) {
            return 4;
        }
        return -1;
    }

    public static ImageProcessor makeProcessor(CMMCore core) {
        return ImageUtils.makeProcessor(core, null);
    }

    public static ImageProcessor makeProcessor(CMMCore core, Object imgArray) {
        int type;
        int w = (int)core.getImageWidth();
        int h = (int)core.getImageHeight();
        int Bpp = (int)core.getBytesPerPixel();
        switch (Bpp) {
            case 1: {
                type = 0;
                break;
            }
            case 2: {
                type = 1;
                break;
            }
            case 4: {
                type = 4;
                break;
            }
            default: {
                type = 0;
            }
        }
        return ImageUtils.makeProcessor(type, w, h, imgArray);
    }

    public static ImageProcessor makeProcessor(int type, int w, int h, Object imgArray) {
        if (imgArray == null) {
            return ImageUtils.makeProcessor(type, w, h);
        }
        switch (type) {
            case 0: {
                return new ByteProcessor(w, h, (byte[])imgArray, null);
            }
            case 1: {
                return new ShortProcessor(w, h, (short[])imgArray, null);
            }
            case 2: {
                return new FloatProcessor(w, h, (float[])imgArray, null);
            }
            case 4: {
                if (imgArray instanceof byte[]) {
                    imgArray = ImageUtils.convertRGB32BytesToInt((byte[])imgArray);
                }
                return new ColorProcessor(w, h, (int[])imgArray);
            }
        }
        return null;
    }

    public static ImageProcessor makeProcessor(TaggedImage taggedImage) {
        JSONObject tags = taggedImage.tags;
        try {
            return ImageUtils.makeProcessor(MDUtils.getIJType(tags), MDUtils.getWidth(tags), MDUtils.getHeight(tags), taggedImage.pix);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    public static ImageProcessor makeProcessor(int type, int w, int h) {
        if (type == 0) {
            return new ByteProcessor(w, h);
        }
        if (type == 1) {
            return new ShortProcessor(w, h);
        }
        if (type == 2) {
            return new FloatProcessor(w, h);
        }
        if (type == 4) {
            return new ColorProcessor(w, h);
        }
        return null;
    }

    public static ImageProcessor makeMonochromeProcessor(TaggedImage taggedImage) {
        try {
            ImageProcessor processor;
            if (MDUtils.isRGB32(taggedImage)) {
                ColorProcessor colorProcessor = new ColorProcessor(MDUtils.getWidth(taggedImage.tags), MDUtils.getHeight(taggedImage.tags), ImageUtils.convertRGB32BytesToInt((byte[])taggedImage.pix));
                processor = colorProcessor.convertToByteProcessor();
            } else {
                processor = ImageUtils.makeProcessor(taggedImage);
            }
            return processor;
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return null;
        }
    }

    public static ImageProcessor subtractImageProcessors(ImageProcessor proc1, ImageProcessor proc2) throws MMException {
        if (proc1.getWidth() != proc2.getWidth() || proc1.getHeight() != proc2.getHeight()) {
            throw new MMException("Error: Images are of unequal size");
        }
        try {
            if (proc1 instanceof ByteProcessor && proc2 instanceof ByteProcessor) {
                return ImageUtils.subtractByteProcessors((ByteProcessor)proc1, (ByteProcessor)proc2);
            }
            if (proc1 instanceof ShortProcessor && proc2 instanceof ShortProcessor) {
                return ImageUtils.subtractShortProcessors((ShortProcessor)proc1, (ShortProcessor)proc2);
            }
            if (proc1 instanceof ShortProcessor && proc2 instanceof ByteProcessor) {
                return ImageUtils.subtractShortByteProcessors((ShortProcessor)proc1, (ByteProcessor)proc2);
            }
            if (proc1 instanceof ShortProcessor && proc2 instanceof FloatProcessor) {
                return ImageUtils.subtractShortFloatProcessors((ShortProcessor)proc1, (FloatProcessor)proc2);
            }
            if (proc1 instanceof FloatProcessor && proc2 instanceof ByteProcessor) {
                return ImageUtils.subtractFloatProcessors((FloatProcessor)proc1, (ByteProcessor)proc2);
            }
            if (proc1 instanceof FloatProcessor && proc2 instanceof ShortProcessor) {
                return ImageUtils.subtractFloatProcessors((FloatProcessor)proc1, (ShortProcessor)proc2);
            }
            if (proc1 instanceof FloatProcessor) {
                return ImageUtils.subtractFloatProcessors((FloatProcessor)proc1, (FloatProcessor)proc2);
            }
            throw new MMException("Types of images to be subtracted were not compatible");
        }
        catch (ClassCastException ex) {
            throw new MMException("Types of images to be subtracted were not compatible");
        }
    }

    public static ImageProcessor subtractFloatProcessors(FloatProcessor proc1, ByteProcessor proc2) {
        return new FloatProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((float[])proc1.getPixels(), (byte[])proc2.getPixels()), null);
    }

    public static ImageProcessor subtractFloatProcessors(FloatProcessor proc1, ShortProcessor proc2) {
        return new FloatProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((float[])proc1.getPixels(), (short[])proc2.getPixels()), null);
    }

    public static ImageProcessor subtractFloatProcessors(FloatProcessor proc1, FloatProcessor proc2) {
        return new FloatProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((float[])proc1.getPixels(), (float[])proc2.getPixels()), null);
    }

    private static ByteProcessor subtractByteProcessors(ByteProcessor proc1, ByteProcessor proc2) {
        return new ByteProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((byte[])proc1.getPixels(), (byte[])proc2.getPixels()), null);
    }

    private static ShortProcessor subtractShortByteProcessors(ShortProcessor proc1, ByteProcessor proc2) {
        return new ShortProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((short[])proc1.getPixels(), (byte[])proc2.getPixels()), null);
    }

    private static ShortProcessor subtractShortProcessors(ShortProcessor proc1, ShortProcessor proc2) {
        return new ShortProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((short[])proc1.getPixels(), (short[])proc2.getPixels()), null);
    }

    private static ShortProcessor subtractShortFloatProcessors(ShortProcessor proc1, FloatProcessor proc2) {
        return new ShortProcessor(proc1.getWidth(), proc1.getHeight(), ImageUtils.subtractPixelArrays((short[])proc1.getPixels(), (float[])proc2.getPixels()), null);
    }

    public static byte[] subtractPixelArrays(byte[] array1, byte[] array2) {
        int l = array1.length;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            result[i] = (byte)Math.max(0, ImageUtils.unsignedValue(array1[i]) - ImageUtils.unsignedValue(array2[i]));
        }
        return result;
    }

    public static short[] subtractPixelArrays(short[] array1, short[] array2) {
        int l = array1.length;
        short[] result = new short[l];
        for (int i = 0; i < l; ++i) {
            result[i] = (short)Math.max(0, ImageUtils.unsignedValue(array1[i]) - ImageUtils.unsignedValue(array2[i]));
        }
        return result;
    }

    public static short[] subtractPixelArrays(short[] array1, byte[] array2) {
        int l = array1.length;
        short[] result = new short[l];
        for (int i = 0; i < l; ++i) {
            result[i] = (short)Math.max(0, ImageUtils.unsignedValue(array1[i]) - ImageUtils.unsignedValue(array2[i]));
        }
        return result;
    }

    public static short[] subtractPixelArrays(short[] array1, float[] array2) {
        int l = array1.length;
        short[] result = new short[l];
        for (int i = 0; i < l; ++i) {
            result[i] = (short)Math.max(0, ImageUtils.unsignedValue(array1[i]) - ImageUtils.unsignedValue((short)array2[i]));
        }
        return result;
    }

    public static float[] subtractPixelArrays(float[] array1, byte[] array2) {
        int l = array1.length;
        float[] result = new float[l];
        for (int i = 0; i < l; ++i) {
            result[i] = array1[i] - (float)ImageUtils.unsignedValue(array2[i]);
        }
        return result;
    }

    public static float[] subtractPixelArrays(float[] array1, short[] array2) {
        int l = array1.length;
        float[] result = new float[l];
        for (int i = 0; i < l; ++i) {
            result[i] = array1[i] - (float)ImageUtils.unsignedValue(array2[i]);
        }
        return result;
    }

    public static float[] subtractPixelArrays(float[] array1, float[] array2) {
        int l = array1.length;
        float[] result = new float[l];
        for (int i = 0; i < l; ++i) {
            result[i] = array1[i] - array2[i];
        }
        return result;
    }

    public static Point findMaxPixel(ImagePlus img) {
        ImageProcessor proc = img.getProcessor();
        float[] pix = (float[])proc.getPixels();
        int width = img.getWidth();
        double max = 0.0;
        int imax = -1;
        for (int i = 0; i < pix.length; ++i) {
            if (!((double)pix[i] > max)) continue;
            max = pix[i];
            imax = i;
        }
        int y = imax / width;
        int x = imax % width;
        return new Point(x, y);
    }

    public static Point findMaxPixel(ImageProcessor proc) {
        int width = proc.getWidth();
        int imax = ImageUtils.findArrayMax(proc.getPixels());
        int y = imax / width;
        int x = imax % width;
        return new Point(x, y);
    }

    public static byte[] get8BitData(Object bytesAsObject) {
        return (byte[])bytesAsObject;
    }

    public static short[] get16BitData(Object shortsAsObject) {
        return (short[])shortsAsObject;
    }

    public static int[] get32BitData(Object intsAsObject) {
        return (int[])intsAsObject;
    }

    public static int findArrayMax(Object pix) {
        if (pix instanceof byte[]) {
            return ImageUtils.findArrayMax((byte[])pix);
        }
        if (pix instanceof int[]) {
            return ImageUtils.findArrayMax((int[])pix);
        }
        if (pix instanceof short[]) {
            return ImageUtils.findArrayMax((short[])pix);
        }
        if (pix instanceof float[]) {
            return ImageUtils.findArrayMax((float[])pix);
        }
        return -1;
    }

    public static int findArrayMax(float[] pix) {
        int imax = -1;
        float max = Float.MIN_VALUE;
        for (int i = 0; i < pix.length; ++i) {
            float pixel = pix[i];
            if (!(pixel > max)) continue;
            max = pixel;
            imax = i;
        }
        return imax;
    }

    public static int findArrayMax(short[] pix) {
        int imax = -1;
        short max = Short.MIN_VALUE;
        for (int i = 0; i < pix.length; ++i) {
            short pixel = pix[i];
            if (pixel <= max) continue;
            max = pixel;
            imax = i;
        }
        return imax;
    }

    public static int findArrayMax(byte[] pix) {
        int imax = -1;
        byte max = -128;
        for (int i = 0; i < pix.length; ++i) {
            byte pixel = pix[i];
            if (pixel <= max) continue;
            max = pixel;
            imax = i;
        }
        return imax;
    }

    public static int findArrayMax(int[] pix) {
        int imax = -1;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < pix.length; ++i) {
            int pixel = pix[i];
            if (pixel <= max) continue;
            max = pixel;
            imax = i;
        }
        return imax;
    }

    public static byte[] convertRGB32IntToBytes(int[] pixels) {
        byte[] bytes = new byte[pixels.length * 4];
        int j = 0;
        for (int i = 0; i < pixels.length; ++i) {
            bytes[j++] = (byte)(pixels[i] & 0xFF);
            bytes[j++] = (byte)(pixels[i] >> 8 & 0xFF);
            bytes[j++] = (byte)(pixels[i] >> 16 & 0xFF);
            bytes[j++] = 0;
        }
        return bytes;
    }

    public static int[] convertRGB32BytesToInt(byte[] pixels) {
        int[] ints = new int[pixels.length / 4];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = pixels[4 * i] + (pixels[4 * i + 1] << 8) + (pixels[4 * i + 2] << 16);
        }
        return ints;
    }

    public static byte[] getRGB32PixelsFromColorPanes(byte[][] planes) {
        int j = 0;
        byte[] pixels = new byte[planes.length * 4];
        for (int i = 0; i < planes.length; ++i) {
            pixels[j++] = planes[2][i];
            pixels[j++] = planes[1][i];
            pixels[j++] = planes[0][i];
            pixels[j++] = 0;
        }
        return pixels;
    }

    public static short[] getRGB64PixelsFromColorPlanes(short[][] planes) {
        int j = -1;
        short[] pixels = new short[planes[0].length * 4];
        for (int i = 0; i < planes[0].length; ++i) {
            pixels[++j] = planes[2][i];
            pixels[++j] = planes[1][i];
            pixels[++j] = planes[0][i];
            pixels[++j] = 0;
        }
        return pixels;
    }

    public static byte[][] getColorPlanesFromRGB32(byte[] pixels) {
        byte[] r = new byte[pixels.length / 4];
        byte[] g = new byte[pixels.length / 4];
        byte[] b = new byte[pixels.length / 4];
        int j = 0;
        for (int i = 0; i < pixels.length / 4; ++i) {
            b[i] = pixels[j++];
            g[i] = pixels[j++];
            r[i] = pixels[j++];
            ++j;
        }
        byte[][] planes = new byte[][]{r, g, b};
        return planes;
    }

    public static short[][] getColorPlanesFromRGB64(short[] pixels) {
        short[] r = new short[pixels.length / 4];
        short[] g = new short[pixels.length / 4];
        short[] b = new short[pixels.length / 4];
        int j = 0;
        for (int i = 0; i < pixels.length / 4; ++i) {
            b[i] = pixels[j++];
            g[i] = pixels[j++];
            r[i] = pixels[j++];
            ++j;
        }
        short[][] planes = new short[][]{r, g, b};
        return planes;
    }

    public static byte[] singleChannelFromRGB32(byte[] pixels, int channel) {
        if (channel != 0 && channel != 1 && channel != 2) {
            return null;
        }
        byte[] p = new byte[pixels.length / 4];
        for (int i = 0; i < p.length; ++i) {
            p[i] = pixels[2 - channel + 4 * i];
        }
        return p;
    }

    public static short[] singleChannelFromRGB64(short[] pixels, int channel) {
        if (channel != 0 && channel != 1 && channel != 2) {
            return null;
        }
        short[] p = new short[pixels.length / 4];
        for (int i = 0; i < p.length; ++i) {
            p[i] = pixels[2 - channel + 4 * i];
        }
        return p;
    }

    public static LUT makeLUT(Color color, double gamma) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int size = 256;
        byte[] rs = new byte[size];
        byte[] gs = new byte[size];
        byte[] bs = new byte[size];
        for (int x = 0; x < size; ++x) {
            double xn = (double)x / (double)(size - 1);
            double yn = Math.pow(xn, gamma);
            rs[x] = (byte)(yn * (double)r);
            gs[x] = (byte)(yn * (double)g);
            bs[x] = (byte)(yn * (double)b);
        }
        return new LUT(8, size, rs, gs, bs);
    }

    public static void setImageStorageClass(Class storageClass) {
        storageClass_ = storageClass;
    }

    public static Class getImageStorageClass() {
        return storageClass_;
    }

    public static TaggedImageStorage newImageStorageInstance(String acqPath, boolean newDataSet, JSONObject summaryMetadata) {
        try {
            return (TaggedImageStorage)storageClass_.getConstructor(String.class, Boolean.class, JSONObject.class).newInstance(acqPath, newDataSet, summaryMetadata);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    public static int unsignedValue(byte b) {
        return b & 0xFF;
    }

    public static int unsignedValue(short s) {
        return s & 0xFFFF;
    }

    public static int getMin(Object pixels) {
        if (pixels instanceof byte[]) {
            byte[] bytes = (byte[])pixels;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < bytes.length; ++i) {
                min = Math.min(min, ImageUtils.unsignedValue(bytes[i]));
            }
            return min;
        }
        if (pixels instanceof short[]) {
            short[] shorts = (short[])pixels;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < shorts.length; ++i) {
                min = Math.min(min, ImageUtils.unsignedValue(shorts[i]));
            }
            return min;
        }
        return -1;
    }

    public static int getMax(Object pixels) {
        if (pixels instanceof byte[]) {
            byte[] bytes = (byte[])pixels;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < bytes.length; ++i) {
                max = Math.max(max, ImageUtils.unsignedValue(bytes[i]));
            }
            return max;
        }
        if (pixels instanceof short[]) {
            short[] shorts = (short[])pixels;
            int min = Integer.MIN_VALUE;
            for (int i = 0; i < shorts.length; ++i) {
                min = Math.max(min, ImageUtils.unsignedValue(shorts[i]));
            }
            return min;
        }
        return -1;
    }

    public static int[] getMinMax(Object pixels) {
        int[] result = new int[2];
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        if (pixels instanceof byte[]) {
            byte[] bytes = (byte[])pixels;
            for (int i = 0; i < bytes.length; ++i) {
                max = Math.max(max, ImageUtils.unsignedValue(bytes[i]));
                min = Math.min(min, ImageUtils.unsignedValue(bytes[i]));
            }
            result[0] = min;
            result[1] = max;
            return result;
        }
        if (pixels instanceof short[]) {
            short[] shorts = (short[])pixels;
            for (int i = 0; i < shorts.length; ++i) {
                min = Math.min(min, ImageUtils.unsignedValue(shorts[i]));
                max = Math.max(max, ImageUtils.unsignedValue(shorts[i]));
            }
            result[0] = min;
            result[1] = max;
            return result;
        }
        return null;
    }

    public static TaggedImage makeTaggedImage(ImageProcessor proc) {
        JSONObject tags = new JSONObject();
        try {
            MDUtils.setChannelIndex(tags, 0);
            MDUtils.setSliceIndex(tags, 0);
            MDUtils.setPositionIndex(tags, 0);
            MDUtils.setFrameIndex(tags, 0);
            MDUtils.setWidth(tags, proc.getWidth());
            MDUtils.setHeight(tags, proc.getHeight());
            MDUtils.setPixelType(tags, ImageUtils.getImageProcessorType(proc));
        }
        catch (Exception e) {
            return null;
        }
        return new TaggedImage(proc.getPixels(), tags);
    }

    public static TaggedImage makeTaggedImage(Object pixels, int channelIndex, int sliceIndex, int positionIndex, int frameIndex, int width, int height, int numberOfBytesPerPixel) {
        JSONObject tags = new JSONObject();
        try {
            MDUtils.setChannelIndex(tags, channelIndex);
            MDUtils.setSliceIndex(tags, sliceIndex);
            MDUtils.setPositionIndex(tags, positionIndex);
            MDUtils.setFrameIndex(tags, frameIndex);
            MDUtils.setWidth(tags, width);
            MDUtils.setHeight(tags, height);
            MDUtils.setPixelTypeFromByteDepth(tags, numberOfBytesPerPixel);
        }
        catch (Exception e) {
            return null;
        }
        return new TaggedImage(pixels, tags);
    }

    public static TaggedImage copyMetadata(TaggedImage image) {
        JSONArray names = image.tags.names();
        String[] keys = new String[names.length()];
        try {
            for (int j = 0; j < names.length(); ++j) {
                keys[j] = names.getString(j);
            }
            return new TaggedImage(image.pix, new JSONObject(image.tags, keys));
        }
        catch (JSONException e) {
            ReportingUtils.logError(e, "Unable to duplicate image metadata");
            return null;
        }
    }

    private static void show(String title, ImageProcessor proc) {
        new ImagePlus(title, proc).show();
    }

    public class MinAndMax {
        int min;
        int max;
    }
}

