/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.micromanager.script.ScriptPanel;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeyAction;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public final class HotKeysDialog
extends MMDialog {
    private final ShortCutTableModel sctModel_ = new ShortCutTableModel();
    private final JComboBox combo_ = new JComboBox();
    private Integer lastTypedKey_ = 0;
    private final KeyEvtHandler keh_;
    private final ArrayList<Integer> keys_ = new ArrayList();
    private final ArrayList<HotKeyAction> actions_ = new ArrayList();
    private final ArrayList<HotKeyAction> possibleActions_ = new ArrayList();
    private String[] possibleActionsAsString_;
    private final Font ourFont_ = new Font("Lucida Grande", 0, 10);
    private final Preferences prefs_;
    public static FileDialogs.FileType MM_HOTKEYS = new FileDialogs.FileType("MM_HOTKEYS", "Micro-Manager HotKeys", System.getProperty("user.home") + "/MMHotKeys", false, null);
    private JButton addButton_;
    private JTable hotKeyTable_;
    private JScrollPane jScrollPane1_;
    private JButton loadButton_;
    private JButton removeButton_;
    private JButton saveButton_;

    public HotKeysDialog() {
        this.initComponents();
        this.prefs_ = this.getPrefsNode();
        this.loadAndRestorePosition(100, 100, 377, 378);
        this.readKeys();
        HotKeys.active_ = false;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                HotKeysDialog.this.hotKeyTable_.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
                HotKeysDialog.this.hotKeyTable_.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
                HotKeysDialog.this.generateKeys();
                HotKeys.active_ = true;
            }
        });
        this.updateComboBox();
        this.hotKeyTable_.setRowSelectionAllowed(false);
        this.hotKeyTable_.setSelectionBackground(Color.white);
        this.hotKeyTable_.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.combo_));
        this.hotKeyTable_.getColumnModel().getColumn(1).setCellEditor(new HotKeyCol1Editor());
        this.hotKeyTable_.getColumnModel().getColumn(0).setCellRenderer(new ActionCollRenderer());
        this.hotKeyTable_.getColumnModel().getColumn(1).setCellRenderer(new HotKeyCol1Renderer());
        this.keh_ = new KeyEvtHandler();
        this.hotKeyTable_.addKeyListener(this.keh_);
        this.setModal(true);
        this.setVisible(true);
    }

    private void generateKeys() {
        HotKeys.keys_.clear();
        for (int i = 0; i < this.keys_.size(); ++i) {
            HotKeys.keys_.put(this.keys_.get(i), this.actions_.get(i));
        }
    }

    private void readKeys() {
        this.keys_.clear();
        this.actions_.clear();
        for (Map.Entry<Integer, HotKeyAction> pairs : HotKeys.keys_.entrySet()) {
            this.keys_.add(pairs.getKey());
            this.actions_.add(pairs.getValue());
        }
    }

    public void updateComboBox() {
        int i;
        int nrScripts = 0;
        ArrayList<File> scriptList = ScriptPanel.getScriptList();
        if (scriptList != null) {
            nrScripts = scriptList.size();
        }
        this.possibleActionsAsString_ = new String[HotKeyAction.NRGUICOMMANDS + nrScripts];
        System.arraycopy(HotKeyAction.guiItems_, 0, this.possibleActionsAsString_, 0, HotKeyAction.guiItems_.length);
        for (i = 0; i < HotKeyAction.NRGUICOMMANDS; ++i) {
            this.possibleActions_.add(i, new HotKeyAction(i));
        }
        if (scriptList != null) {
            for (i = 0; i < scriptList.size(); ++i) {
                this.possibleActions_.add(i + HotKeyAction.NRGUICOMMANDS, new HotKeyAction(scriptList.get(i)));
                this.possibleActionsAsString_[i + HotKeyAction.NRGUICOMMANDS] = scriptList.get(i).getName();
            }
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.possibleActionsAsString_);
        this.combo_.setModel(model);
        this.combo_.setFont(this.ourFont_);
    }

    private void initComponents() {
        this.jScrollPane1_ = new JScrollPane();
        this.hotKeyTable_ = new JTable();
        this.addButton_ = new JButton();
        this.removeButton_ = new JButton();
        this.loadButton_ = new JButton();
        this.saveButton_ = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.jScrollPane1_.setMinimumSize(new Dimension(23, 15));
        this.jScrollPane1_.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.hotKeyTable_.setFont(new Font("Lucida Grande", 0, 10));
        this.hotKeyTable_.setModel(this.sctModel_);
        this.jScrollPane1_.setViewportView(this.hotKeyTable_);
        this.addButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.addButton_.setText("Add");
        this.addButton_.setMinimumSize(new Dimension(75, 20));
        this.addButton_.setPreferredSize(new Dimension(75, 20));
        this.addButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HotKeysDialog.this.addButton_ActionPerformed(evt);
            }
        });
        this.removeButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.removeButton_.setText("Remove");
        this.removeButton_.setMinimumSize(new Dimension(75, 20));
        this.removeButton_.setPreferredSize(new Dimension(75, 20));
        this.removeButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HotKeysDialog.this.removeButton_ActionPerformed(evt);
            }
        });
        this.loadButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.loadButton_.setText("Load");
        this.loadButton_.setMinimumSize(new Dimension(75, 20));
        this.loadButton_.setPreferredSize(new Dimension(75, 20));
        this.loadButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HotKeysDialog.this.loadButton_ActionPerformed(evt);
            }
        });
        this.saveButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.saveButton_.setText("Save");
        this.saveButton_.setMinimumSize(new Dimension(75, 20));
        this.saveButton_.setPreferredSize(new Dimension(75, 20));
        this.saveButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HotKeysDialog.this.saveButton_ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton_, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton_, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.loadButton_, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton_, -2, -1, -2)).addComponent(this.jScrollPane1_, -1, 377, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton_, -2, 20, -2).addComponent(this.removeButton_, -2, 20, -2).addComponent(this.saveButton_, -2, 20, -2).addComponent(this.loadButton_, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1_, -1, -1, Short.MAX_VALUE).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void addButton_ActionPerformed(ActionEvent evt) {
        this.keys_.add(32);
        this.actions_.add(new HotKeyAction(0));
        this.sctModel_.fireTableRowsInserted(this.keys_.size() - 1, this.keys_.size());
        this.sctModel_.fireTableDataChanged();
    }

    private void removeButton_ActionPerformed(ActionEvent evt) {
        this.hotKeyTable_.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
        this.hotKeyTable_.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
        int[] rows = this.hotKeyTable_.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.keys_.remove(rows[i]);
            this.actions_.remove(rows[i]);
        }
        this.sctModel_.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        this.sctModel_.fireTableDataChanged();
    }

    private void loadButton_ActionPerformed(ActionEvent evt) {
        File f = FileDialogs.openFile(this, "Load ShortCuts", MM_HOTKEYS);
        if (f != null && f.canRead()) {
            try {
                HotKeys.load(f);
                this.readKeys();
                this.sctModel_.fireTableDataChanged();
            }
            catch (FileNotFoundException ex) {
                ReportingUtils.showError("Could not find the file");
            }
        }
    }

    private void saveButton_ActionPerformed(ActionEvent evt) {
        this.generateKeys();
        try {
            File f = FileDialogs.save(this, "Save Shortcuts", MM_HOTKEYS);
            if (f == null) {
                return;
            }
            f.createNewFile();
            try {
                HotKeys.save(f);
            }
            catch (FileNotFoundException ex) {
                ReportingUtils.showError("File not found");
            }
        }
        catch (IOException ex) {
            ReportingUtils.showError("Failed to create file");
        }
    }

    public class HotKeyCol1Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        JLabel keyLabel = new JLabel();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            if (value != null) {
                this.keyLabel.setText((String)value);
            } else {
                this.keyLabel.setText("m");
            }
            this.keyLabel.setForeground(Color.red);
            this.keyLabel.setFocusable(true);
            this.keyLabel.setFont(HotKeysDialog.this.ourFont_);
            HotKeysDialog.this.lastTypedKey_ = (Integer)HotKeysDialog.this.keys_.get(rowIndex);
            HotKeysDialog.this.keh_.setLabel(this.keyLabel);
            return this.keyLabel;
        }

        @Override
        public Object getCellEditorValue() {
            return HotKeysDialog.this.lastTypedKey_;
        }
    }

    public class KeyEvtHandler
    implements KeyListener {
        JLabel label_;

        public void setLabel(JLabel label) {
            this.label_ = label;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            Integer value = ke.getKeyCode();
            if (!HotKeysDialog.this.keys_.contains(value) || value.intValue() == ((Integer)HotKeysDialog.this.keys_.get(HotKeysDialog.this.hotKeyTable_.getSelectedRow())).intValue()) {
                HotKeysDialog.this.lastTypedKey_ = value;
                if (this.label_ != null) {
                    this.label_.setText(KeyEvent.getKeyText(HotKeysDialog.this.lastTypedKey_));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }
    }

    public class HotKeyCol1Renderer
    extends DefaultTableCellRenderer {
        public void SetValue(Object value) {
            this.setText(KeyEvent.getKeyText((Integer)value));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            res.setBackground(Color.white);
            res.setForeground(Color.black);
            return res;
        }
    }

    public class ActionCollRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            res.setBackground(Color.white);
            res.setForeground(Color.black);
            return res;
        }
    }

    public class ShortCutTableModel
    extends AbstractTableModel {
        private static final int columnCount_ = 2;

        @Override
        public int getRowCount() {
            if (HotKeysDialog.this.keys_ != null) {
                return HotKeysDialog.this.keys_.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Action";
            }
            return "HotKey";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                if (row > HotKeysDialog.this.actions_.size()) {
                    return null;
                }
                HotKeyAction action = (HotKeyAction)HotKeysDialog.this.actions_.get(row);
                if (action != null) {
                    if (action.type_ == 0) {
                        return HotKeyAction.guiItems_[action.guiCommand_];
                    }
                    return action.beanShellScript_.getName();
                }
            }
            if (column == 1) {
                if (row > HotKeysDialog.this.keys_.size()) {
                    return null;
                }
                return KeyEvent.getKeyText((Integer)HotKeysDialog.this.keys_.get(row));
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean found = false;
            if (col == 0) {
                for (int i = 0; i < HotKeysDialog.this.possibleActionsAsString_.length && !found; ++i) {
                    if (!HotKeysDialog.this.possibleActionsAsString_[i].equals(value)) continue;
                    found = true;
                    HotKeysDialog.this.actions_.set(row, HotKeysDialog.this.possibleActions_.get(i));
                }
            }
            if (col == 1 && !HotKeysDialog.this.keys_.contains((Integer)value)) {
                HotKeysDialog.this.keys_.set(row, (Integer)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

