/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.micromanager.utils.HotKeyAction;
import org.micromanager.utils.ReportingUtils;

public class HotKeys {
    Preferences root_ = Preferences.userNodeForPackage(this.getClass());
    private static Preferences prefs_;
    private static final int STOP = -1;
    private static final String KEY = "Key";
    private static final String TYPE = "Type";
    private static final String GUICOMMAND = "GuiCommand";
    private static final String FILENAME = "FileName";
    public static final LinkedHashMap<Integer, HotKeyAction> keys_;
    public static boolean active_;

    public HotKeys() {
        prefs_ = this.root_.node(this.root_.absolutePath() + "/HotKeys");
    }

    public void loadSettings() {
        int key;
        if (prefs_ == null) {
            return;
        }
        int j = 0;
        do {
            if ((key = prefs_.getInt(KEY + j, -1)) != -1) {
                HotKeyAction action;
                int type = prefs_.getInt(TYPE + j, 0);
                if (type == 0) {
                    int guiCommand = prefs_.getInt(GUICOMMAND + j, 0);
                    action = new HotKeyAction(guiCommand);
                    keys_.put(key, action);
                } else {
                    File file = new File(prefs_.get(FILENAME + j, ""));
                    action = new HotKeyAction(file);
                    keys_.put(key, action);
                }
            }
            ++j;
        } while (key != -1);
    }

    public void saveSettings() {
        if (prefs_ == null) {
            return;
        }
        Iterator<Map.Entry<Integer, HotKeyAction>> it = keys_.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Integer, HotKeyAction> pairs = it.next();
            prefs_.putInt(KEY + i, pairs.getKey());
            HotKeyAction action = pairs.getValue();
            prefs_.putInt(TYPE + i, action.type_);
            if (action.type_ == 0) {
                prefs_.putInt(GUICOMMAND + i, action.guiCommand_);
            } else {
                prefs_.put(FILENAME + i, action.beanShellScript_.getAbsolutePath());
            }
            ++i;
        }
        prefs_.putInt(KEY + i, -1);
    }

    public static void load(File f) throws FileNotFoundException {
        if (f == null || !f.canRead()) {
            return;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
        keys_.clear();
        try {
            while (in.available() > 0) {
                HotKeyAction action;
                int key = in.readInt();
                int type = in.readInt();
                String filePath = "";
                if (type == 0) {
                    int guiCommand = in.readInt();
                    action = new HotKeyAction(guiCommand);
                    keys_.put(key, action);
                    continue;
                }
                int strLength = in.readInt();
                for (int i = 0; i < strLength; ++i) {
                    filePath = filePath + in.readChar();
                }
                action = new HotKeyAction(new File(filePath));
                keys_.put(key, action);
            }
            in.close();
        }
        catch (IOException ex) {
            ReportingUtils.showError("Error while reading in Shortcuts");
        }
    }

    public static void save(File f) throws FileNotFoundException {
        if (f == null || !f.canWrite()) {
            return;
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        Iterator<Map.Entry<Integer, HotKeyAction>> it = keys_.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            try {
                Map.Entry<Integer, HotKeyAction> pairs = it.next();
                out.writeInt(pairs.getKey());
                HotKeyAction action = pairs.getValue();
                out.writeInt(action.type_);
                if (action.type_ == 0) {
                    out.writeInt(action.guiCommand_);
                } else {
                    out.writeInt(action.beanShellScript_.getAbsolutePath().length());
                    out.writeChars(action.beanShellScript_.getAbsolutePath());
                }
                ++i;
            }
            catch (IOException ex) {
                ReportingUtils.showError("Error while saving Shortcuts");
            }
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            ReportingUtils.showError("Error while closing Shortcuts file");
        }
    }

    static {
        keys_ = new LinkedHashMap();
        active_ = true;
    }
}

