/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

public class HistogramUtils {
    int[] histogram_;
    int totalPoints_;
    double fractionToReject_;

    public HistogramUtils(int[] histogram, int totalPoints) {
        this.histogram_ = histogram;
        this.totalPoints_ = totalPoints;
        this.fractionToReject_ = 0.0027;
    }

    public HistogramUtils(int[] histogram) {
        this.histogram_ = histogram;
        this.totalPoints_ = 0;
        this.fractionToReject_ = 0.0027;
    }

    public HistogramUtils(int[] histogram, int totalPoints, double f) {
        this.histogram_ = histogram;
        this.totalPoints_ = totalPoints;
        this.fractionToReject_ = f;
    }

    public HistogramUtils(int[] histogram, double f) {
        this.histogram_ = histogram;
        this.totalPoints_ = 0;
        this.fractionToReject_ = f;
    }

    public int getMin() {
        int ret = 0;
        if (null != this.histogram_) {
            for (int i = 0; i < this.histogram_.length; ++i) {
                if (0 >= this.histogram_[i]) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public int getMax() {
        int ret = 0;
        if (null != this.histogram_) {
            for (int i = this.histogram_.length - 1; 0 <= i; --i) {
                if (0 >= this.histogram_[i]) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    int sumTotalPoints() {
        int t = 0;
        for (int i = 0; i < this.histogram_.length; ++i) {
            t += this.histogram_[i];
        }
        return t;
    }

    public int getMinAfterRejectingOutliers() {
        int ret = 0;
        if (this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        int maxOutliers = (int)(0.5 + (double)this.totalPoints_ * this.fractionToReject_);
        int outliers = 0;
        for (int iterator = 0; iterator < this.histogram_.length; ++iterator) {
            if ((outliers += this.histogram_[iterator]) <= maxOutliers) continue;
            ret = Math.max(0, iterator);
            break;
        }
        return ret;
    }

    public int getMaxAfterRejectingOutliers() {
        int ret = 0;
        if (this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        int maxOutliers = (int)(0.5 + (double)this.totalPoints_ * this.fractionToReject_);
        int outliers = 0;
        for (int iterator = this.histogram_.length - 1; iterator >= 0; --iterator) {
            if ((outliers += this.histogram_[iterator]) <= maxOutliers) continue;
            ret = Math.min(iterator, this.histogram_.length - 1);
            break;
        }
        return ret;
    }

    public double getFractionToReject() {
        return this.fractionToReject_;
    }

    public int getTotalPoints() {
        if (null != this.histogram_ && this.totalPoints_ < 1) {
            this.totalPoints_ = this.sumTotalPoints();
        }
        return this.totalPoints_;
    }

    public void setFractionToReject(double f) {
        this.fractionToReject_ = f;
    }
}

