/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.text.ParseException;
import java.util.Hashtable;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class GammaSliderCalculator {
    final double c0_ = 0.1;
    final double c1_ = 0.02714285;
    final double c2_ = 0.014857150000000001;
    final double c3_ = 0.003142855;
    double min_ = 0.1;
    double max_ = 5.0;
    int low_ = 0;
    int high_ = 100;
    Hashtable<Integer, Double> gammas_;
    Hashtable<Double, Integer> values_;

    public GammaSliderCalculator(int low, int high) {
        this.gammas_ = new Hashtable(high - low + 1, 1.0f);
        this.values_ = new Hashtable(high - low + 1, 1.0f);
        for (int i = low; i <= high; ++i) {
            try {
                double gamma = NumberUtils.displayStringToDouble(NumberUtils.doubleToDisplayString(this.calculateGamma(i)));
                this.gammas_.put(new Integer(i), gamma);
                this.values_.put(gamma, new Integer(i));
                continue;
            }
            catch (ParseException p) {
                ReportingUtils.logMessage("Caught ParseException");
            }
        }
        this.low_ = low;
        this.high_ = high;
        this.min_ = this.gammas_.get(low);
        this.max_ = this.gammas_.get(high);
    }

    public double sliderToGamma(int sliderSetting) {
        return this.gammas_.get(sliderSetting);
    }

    public int gammaToSlider(double gamma) {
        if (gamma < this.min_) {
            gamma = this.min_;
        }
        if (gamma > this.max_) {
            gamma = this.max_;
        }
        try {
            gamma = NumberUtils.displayStringToDouble(NumberUtils.doubleToDisplayString(gamma));
            Integer test = this.values_.get(gamma);
            if (test != null) {
                return test;
            }
        }
        catch (ParseException p) {
            ReportingUtils.logMessage("Caught ParseException");
        }
        int guess = (this.low_ + this.high_) / 2;
        int lastGuess = this.low_;
        int diff = guess;
        for (int i = 0; diff > 1 && i < 10; ++i) {
            diff = Math.abs(guess - lastGuess);
            lastGuess = guess;
            if (gamma > this.gammas_.get(guess)) {
                guess += diff / 2;
                continue;
            }
            guess -= diff / 2;
        }
        return guess;
    }

    private double calculateGamma(int sliderSetting) {
        double x = (double)sliderSetting / 10.0;
        return this.calculateGamma10(x);
    }

    private double calculateGamma10(double x) {
        return 0.1 + 0.02714285 * x + 0.014857150000000001 * x * x + 0.003142855 * x * x * x;
    }

    private int calculateSlider(double gamma) {
        double estimate = 5.0;
        for (int i = 0; Math.abs(this.calculateGamma10(estimate) - gamma) > 0.002 && i < 5; ++i) {
            double denominator = 0.009428565 * estimate * estimate + 0.029714300000000003 * estimate + 0.02714285;
            estimate -= (this.calculateGamma10(estimate) - gamma) / denominator;
        }
        return (int)(10.0 * estimate);
    }
}

