/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import com.swtdesigner.SwingResourceManager;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.BrowserLauncher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.micromanager.MMStudio;
import org.micromanager.utils.ImageFocusListener;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TooltipTextMaker;

public class GUIUtils {
    private static final String DIALOG_POSITION = "dialogPosition";
    private static HashSet<Class> windowsWithPersistedPositions = new HashSet();

    public static void setComboSelection(JComboBox cb, String sel) {
        int i;
        ActionListener[] listeners = cb.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            cb.removeActionListener(listeners[i]);
        }
        cb.setSelectedItem(sel);
        for (i = 0; i < listeners.length; ++i) {
            cb.addActionListener(listeners[i]);
        }
    }

    public static void replaceComboContents(JComboBox cb, String[] items) {
        int i;
        ActionListener[] listeners = cb.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            cb.removeActionListener(listeners[i]);
        }
        if (cb.getItemCount() > 0) {
            cb.removeAllItems();
        }
        for (i = 0; i < items.length; ++i) {
            cb.addItem(items[i]);
        }
        for (i = 0; i < listeners.length; ++i) {
            cb.addActionListener(listeners[i]);
        }
    }

    public static ChangeListener[] detachChangeListeners(JSpinner spinner) {
        ChangeListener[] listeners;
        for (ChangeListener listener : listeners = spinner.getChangeListeners()) {
            spinner.removeChangeListener(listener);
        }
        return listeners;
    }

    public static void reattachChangeListeners(JSpinner spinner, ChangeListener[] listeners) {
        for (ChangeListener listener : listeners) {
            spinner.addChangeListener(listener);
        }
    }

    public static void replaceSpinnerValue(JSpinner spinner, double value) {
        ChangeListener[] listeners = GUIUtils.detachChangeListeners(spinner);
        spinner.setValue(value);
        GUIUtils.reattachChangeListeners(spinner, listeners);
    }

    public static void preventDisplayAdapterChangeExceptions() {
        try {
            if (JavaUtils.isWindows()) {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Class<?> envClass = cl.loadClass("sun.awt.Win32GraphicsEnvironment");
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                envClass.getDeclaredMethod("displayChanged", new Class[0]).invoke(envClass.cast(ge), new Object[0]);
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
    }

    public static void setClickCountToStartEditing(JTable table, int count) {
        for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
            TableCellEditor cellEditor = table.getColumnModel().getColumn(columnIndex).getCellEditor();
            if (!(cellEditor instanceof DefaultCellEditor)) continue;
            ((DefaultCellEditor)cellEditor).setClickCountToStart(count);
        }
    }

    public static void stopEditingOnLosingFocus(JTable table) {
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public static boolean isLocationInScreenBounds(Point location) {
        GraphicsConfiguration config = GUIUtils.getGraphicsConfigurationContaining(location.x, location.y);
        return config != null;
    }

    public static Rectangle getMaxWindowSizeForPoint(int x, int y) {
        GraphicsConfiguration config = GUIUtils.getGraphicsConfigurationContaining(x, y);
        if (config == null) {
            x = Math.max(x, 0);
            y = Math.max(y, 0);
            config = GUIUtils.getGraphicsConfigurationContaining(x, y);
        }
        if (config == null) {
            ReportingUtils.logError("Couldn't find a display containing the point (" + x + ", " + y + ")");
            return null;
        }
        return config.getBounds();
    }

    public static GraphicsConfiguration getGraphicsConfigurationContaining(int x, int y) {
        GraphicsDevice[] devices;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : devices = env.getScreenDevices()) {
            GraphicsConfiguration[] configs;
            for (GraphicsConfiguration config : configs = device.getConfigurations()) {
                Rectangle bounds = config.getBounds();
                if (!bounds.contains(x, y)) continue;
                return config;
            }
        }
        return null;
    }

    private static Preferences getWindowPrefs(Window win) {
        return Preferences.userNodeForPackage(GUIUtils.class).node("window_prefs").node(win.getClass().getName());
    }

    private static void storePosition(Window win) {
        Preferences prefs = GUIUtils.getWindowPrefs(win);
        JavaUtils.putObjectInPrefs(prefs, DIALOG_POSITION, win.getLocation());
    }

    public static void recallPosition(final Window win) {
        if (!windowsWithPersistedPositions.contains(win.getClass())) {
            Preferences prefs = GUIUtils.getWindowPrefs(win);
            Point dialogPosition = JavaUtils.getObjectFromPrefs(prefs, DIALOG_POSITION, null);
            if (dialogPosition == null || !GUIUtils.isLocationInScreenBounds(dialogPosition)) {
                Dimension screenDims = JavaUtils.getScreenDimensions();
                dialogPosition = new Point((screenDims.width - win.getWidth()) / 2, (screenDims.height - win.getHeight()) / 2);
            }
            win.setLocation(dialogPosition);
            win.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    GUIUtils.storePosition(win);
                }
            });
            windowsWithPersistedPositions.add(win.getClass());
        }
    }

    public static void registerImageFocusListener(final ImageFocusListener listener) {
        AWTEventListener awtEventListener = new AWTEventListener(){
            private ImageWindow currentImageWindow_ = null;

            @Override
            public void eventDispatched(AWTEvent event) {
                ImageWindow focusedWindow;
                if (event instanceof WindowEvent && 0 != (event.getID() & 0xCF) && event.getSource() instanceof ImageWindow && this.currentImageWindow_ != (focusedWindow = WindowManager.getCurrentWindow())) {
                    listener.focusReceived(focusedWindow);
                    this.currentImageWindow_ = focusedWindow;
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(awtEventListener, 524288L);
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
    }

    public static void invokeLater(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void setToolTipText(JComponent component, String toolTipText) {
        if (JavaUtils.isMac()) {
            component.setToolTipText(toolTipText);
        } else {
            component.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip(toolTipText));
        }
    }

    public static void setIcon(AbstractButton component, String iconFileName) {
        component.setIcon(SwingResourceManager.getIcon(MMStudio.class, "/org/micromanager/icons/" + iconFileName));
    }

    public static JMenu createMenuInMenuBar(JMenuBar menuBar, String menuName) {
        JMenu menu = new JMenu();
        menu.setText(menuName);
        menuBar.add(menu);
        return menu;
    }

    public static JMenuItem addMenuItem(JMenu parentMenu, JMenuItem menuItem, String menuItemToolTip, final Runnable menuActionRunnable) {
        if (menuItemToolTip != null) {
            GUIUtils.setToolTipText(menuItem, menuItemToolTip);
        }
        if (menuActionRunnable != null) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ignoreEvent) {
                    menuActionRunnable.run();
                }
            });
        }
        parentMenu.add(menuItem);
        return menuItem;
    }

    public static JMenuItem addMenuItem(JMenu parentMenu, String menuItemText, String menuItemToolTip, Runnable menuActionRunnable) {
        return GUIUtils.addMenuItem(parentMenu, new JMenuItem(menuItemText), menuItemToolTip, menuActionRunnable);
    }

    public static JMenuItem addMenuItem(JMenu parentMenu, String menuItemText, String menuItemToolTip, Runnable menuActionRunnable, String iconFileName) {
        JMenuItem menuItem = GUIUtils.addMenuItem(parentMenu, menuItemText, menuItemToolTip, menuActionRunnable);
        GUIUtils.setIcon(menuItem, iconFileName);
        return menuItem;
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(JMenu parentMenu, String menuItemText, String menuItemToolTip, Runnable menuActionRunnable, boolean initState) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)GUIUtils.addMenuItem(parentMenu, new JCheckBoxMenuItem(menuItemText), menuItemToolTip, menuActionRunnable);
        menuItem.setSelected(initState);
        return menuItem;
    }

    public static void addWithEdges(Container parentContainer, JComponent component, int west, int north, int east, int south) {
        parentContainer.add(component);
        SpringLayout topLayout = (SpringLayout)parentContainer.getLayout();
        topLayout.putConstraint("East", (Component)component, east, east > 0 ? "West" : "East", (Component)parentContainer);
        topLayout.putConstraint("West", (Component)component, west, west >= 0 ? "West" : "East", (Component)parentContainer);
        topLayout.putConstraint("South", (Component)component, south, south > 0 ? "North" : "South", (Component)parentContainer);
        topLayout.putConstraint("North", (Component)component, north, north >= 0 ? "North" : "South", (Component)parentContainer);
    }

    public static AbstractButton createButton(boolean isToggleButton, String name, String text, String toolTipText, final Runnable buttonActionRunnable, String iconFileName, Container parentPanel, int west, int north, int east, int south) {
        AbstractButton button = isToggleButton ? new JToggleButton() : new JButton();
        button.setFont(new Font("Arial", 0, 10));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setName(name);
        if (text != null) {
            button.setText(text);
        }
        if (iconFileName != null) {
            button.setIconTextGap(4);
            GUIUtils.setIcon(button, iconFileName);
        }
        if (toolTipText != null) {
            button.setToolTipText(toolTipText);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonActionRunnable.run();
            }
        });
        GUIUtils.addWithEdges(parentPanel, button, west, north, east, south);
        return button;
    }

    public static InputVerifier textFieldInputVerifier(final JTextField field, final StringValidator validator) {
        return new InputVerifier(){
            private String lastGoodValue;
            {
                this.lastGoodValue = field.getText();
            }

            @Override
            public boolean verify(JComponent input) {
                String proposedValue = ((JTextField)input).getText();
                validator.validate(proposedValue);
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent input) {
                try {
                    boolean isValid = super.shouldYieldFocus(input);
                    this.lastGoodValue = field.getText();
                    return isValid;
                }
                catch (Exception e) {
                    int response = JOptionPane.showConfirmDialog(null, e.getMessage(), "Invalid input", 2);
                    if (response == 0) {
                        return false;
                    }
                    if (response == 2) {
                        field.setText(this.lastGoodValue);
                        return true;
                    }
                    return true;
                }
            }
        };
    }

    public static void enforceValidTextField(JTextField field, StringValidator validator) {
        field.setInputVerifier(GUIUtils.textFieldInputVerifier(field, validator));
    }

    public static DefaultCellEditor validatingDefaultCellEditor(StringValidator validator) {
        final String[] lastValue = new String[]{""};
        final JTextField field = new JTextField();
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                lastValue[0] = field.getText();
            }
        });
        final InputVerifier verifier = GUIUtils.textFieldInputVerifier(field, validator);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public boolean stopCellEditing() {
                return verifier.shouldYieldFocus(field) && super.stopCellEditing();
            }
        };
        return editor;
    }

    public static StringValidator integerStringValidator(final int minValue, final int maxValue) {
        return new StringValidator(){

            @Override
            public void validate(String string) {
                try {
                    int value = Integer.parseInt(string.trim());
                    if (value < minValue || value > maxValue) {
                        throw new RuntimeException("Value should be between " + minValue + " and " + maxValue);
                    }
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Please enter an integer.");
                }
            }
        };
    }

    public static StringValidator floatStringValidator(final double minValue, final double maxValue) {
        return new StringValidator(){

            @Override
            public void validate(String string) {
                try {
                    double value = Double.parseDouble(string);
                    if (value < minValue || value > maxValue) {
                        throw new RuntimeException("Value should be between " + minValue + " and " + maxValue);
                    }
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Please enter a number.");
                }
            }
        };
    }

    public static void enforceIntegerTextField(JTextField field, int minValue, int maxValue) {
        GUIUtils.enforceValidTextField(field, GUIUtils.integerStringValidator(minValue, maxValue));
    }

    public static void enforceFloatFieldText(JTextField field, double minValue, double maxValue) {
        GUIUtils.enforceValidTextField(field, GUIUtils.floatStringValidator(minValue, maxValue));
    }

    public static void enforceIntegerTextColumn(JTable table, int columnInt, int minValue, int maxValue) {
        table.getColumnModel().getColumn(columnInt).setCellEditor(GUIUtils.validatingDefaultCellEditor(GUIUtils.integerStringValidator(minValue, maxValue)));
    }

    public static String getStringValue(JComponent component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem().toString();
        }
        if (component instanceof JList) {
            return ((JList)component).getSelectedValue().toString();
        }
        return null;
    }

    public static void setValue(JComponent component, String value) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(value);
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedItem(value);
        }
        if (component instanceof JList) {
            ((JList)component).setSelectedValue(value, true);
        }
    }

    public static void setValue(JComponent component, Object value) {
        String valueText = value.toString();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(valueText);
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedItem(valueText);
        }
        if (component instanceof JList) {
            ((JList)component).setSelectedValue(valueText, true);
        }
    }

    public static int getIntValue(JTextField component) {
        return Integer.parseInt(component.getText());
    }

    private static void enableOnTableEvent(final JTable table, final JComponent component) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && component.getParent().isEnabled()) {
                    if (table.getSelectedRowCount() > 0) {
                        component.setEnabled(true);
                    } else {
                        component.setEnabled(false);
                    }
                }
            }
        });
    }

    public static void makeIntoMoveRowUpButton(final JTable table, JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = table.getSelectedRow();
                if (rowIndex > 0) {
                    ((DefaultTableModel)table.getModel()).moveRow(rowIndex, rowIndex, rowIndex - 1);
                    table.setRowSelectionInterval(rowIndex - 1, rowIndex - 1);
                }
            }
        });
        GUIUtils.enableOnTableEvent(table, button);
    }

    public static void makeIntoMoveRowDownButton(final JTable table, JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = table.getSelectedRow();
                if (rowIndex < table.getRowCount() - 1) {
                    ((DefaultTableModel)table.getModel()).moveRow(rowIndex, rowIndex, rowIndex + 1);
                    table.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
                }
            }
        });
        GUIUtils.enableOnTableEvent(table, button);
    }

    public static void makeIntoDeleteRowButton(final JTable table, JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = table.getSelectedRow();
                DefaultTableModel model = (DefaultTableModel)table.getModel();
                model.removeRow(rowIndex);
                if (rowIndex < table.getRowCount()) {
                    table.setRowSelectionInterval(rowIndex, rowIndex);
                }
            }
        });
        GUIUtils.enableOnTableEvent(table, button);
    }

    public static void makeIntoCloneRowButton(final JTable table, JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = table.getSelectedRow();
                DefaultTableModel model = (DefaultTableModel)table.getModel();
                Vector rowData = model.getDataVector().elementAt(rowIndex);
                model.insertRow(rowIndex + 1, new Vector(rowData));
                table.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
            }
        });
        GUIUtils.enableOnTableEvent(table, button);
    }

    public static void startEditingAtCell(JTable table, int row, int column) {
        table.editCellAt(row, column);
        table.getEditorComponent().requestFocusInWindow();
    }

    public static void tabKeyTraversesTable(final JTable table) {
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    int row = table.getEditingRow();
                    int column = table.getEditingColumn();
                    if (row < 0 || column < 0) {
                        return;
                    }
                    if (column == table.getColumnCount() - 1) {
                        column = 0;
                        row += 1 % table.getRowCount();
                    } else {
                        ++column;
                    }
                    GUIUtils.startEditingAtCell(table, row, column);
                }
            }
        });
    }

    public static Runnable makeURLRunnable(final String url) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserLauncher.openURL((String)url);
                }
                catch (IOException e1) {
                    ReportingUtils.showError(e1);
                }
            }
        };
    }

    public static interface StringValidator {
        public void validate(String var1);
    }
}

