/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.micromanager.utils.JavaUtils;

public class FileDialogs {
    public static File show(Window parent, String title, File startFile, boolean selectDirectories, boolean load, String fileDescription, String[] fileSuffixes, boolean suggestFileName) {
        File selectedFile = null;
        GeneralFileFilter filter = new GeneralFileFilter(fileDescription, fileSuffixes);
        if (JavaUtils.isMac()) {
            int mode;
            if (selectDirectories) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            int n = mode = load ? 0 : 1;
            FileDialog fd = parent instanceof Dialog ? new FileDialog((Dialog)parent, title, mode) : (parent instanceof Frame ? new FileDialog((Frame)parent, title, mode) : new FileDialog((Dialog)null, title, mode));
            if (startFile != null) {
                if (startFile.isDirectory()) {
                    fd.setDirectory(startFile.getAbsolutePath());
                } else {
                    fd.setDirectory(startFile.getParent());
                }
                if (!load && suggestFileName) {
                    fd.setFile(startFile.getName());
                }
            }
            if (fileSuffixes != null) {
                fd.setFilenameFilter(filter);
            }
            fd.setVisible(true);
            if (selectDirectories) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            if (fd.getFile() != null) {
                selectedFile = new File(fd.getDirectory() + "/" + fd.getFile());
                if (mode == 1 && !filter.accept(selectedFile)) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + "." + fileSuffixes[0]);
                }
            }
            fd.dispose();
        } else {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            if (startFile != null) {
                if (!load && suggestFileName || startFile.isDirectory()) {
                    fc.setSelectedFile(startFile);
                } else {
                    fc.setSelectedFile(startFile.getParentFile());
                }
            }
            fc.setDialogTitle(title);
            if (selectDirectories) {
                fc.setFileSelectionMode(2);
            }
            if (fileSuffixes != null) {
                fc.setFileFilter(filter);
            }
            if ((returnVal = load ? fc.showOpenDialog(parent) : fc.showSaveDialog(parent)) == 0) {
                selectedFile = fc.getSelectedFile();
            }
        }
        return selectedFile;
    }

    public static File show(Window parent, String title, FileType type, boolean selectDirectories, boolean load) {
        File result;
        Preferences node = Preferences.userNodeForPackage(FileDialogs.class);
        String startFile = node.get(type.name, type.defaultFileName);
        File startDir = null;
        if (startFile != null) {
            startDir = new File(startFile);
        }
        if ((result = FileDialogs.show(parent, title, startDir, selectDirectories, load, type.description, type.suffixes, type.suggestFileOnSave)) != null) {
            node.put(type.name, result.getAbsolutePath());
        }
        return result;
    }

    public static void storePath(FileType type, File path) {
        Preferences.userNodeForPackage(FileDialogs.class).put(type.name, path.getAbsolutePath());
    }

    public static File openFile(Window parent, String title, FileType type) {
        return FileDialogs.show(parent, title, type, false, true);
    }

    public static File openDir(Window parent, String title, FileType type) {
        return FileDialogs.show(parent, title, type, true, true);
    }

    public static File save(Window parent, String title, FileType type) {
        return FileDialogs.show(parent, title, type, false, false);
    }

    private static class GeneralFileFilter
    extends FileFilter
    implements FilenameFilter {
        private final String fileDescription_;
        private final String[] fileSuffixes_;

        public GeneralFileFilter(String fileDescription, String[] fileSuffixes) {
            this.fileDescription_ = fileDescription;
            this.fileSuffixes_ = fileSuffixes;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            int n = name.lastIndexOf(".");
            String suffix = name.substring(1 + n).toLowerCase();
            if (this.fileSuffixes_ == null || this.fileSuffixes_.length == 0) {
                return true;
            }
            if (!JavaUtils.isMac() && pathname.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.fileSuffixes_.length; ++i) {
                if (this.fileSuffixes_[i] == null || !this.fileSuffixes_[i].toLowerCase().contentEquals(suffix)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.fileDescription_;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }
    }

    public static class FileType {
        final String name;
        final String[] suffixes;
        final String description;
        final boolean suggestFileOnSave;
        final String defaultFileName;

        public FileType(String name, String description, String defaultFileName, boolean suggestFileOnSave, String ... suffixes) {
            this.name = name;
            this.description = description;
            this.suffixes = suffixes;
            this.defaultFileName = defaultFileName;
            this.suggestFileOnSave = suggestFileOnSave;
        }
    }
}

