/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class EDTProfiler {
    private static final int INTERVAL = 100;
    private Timer timer_ = new Timer();
    private final LinkedList<Long> startTimes_ = new LinkedList();
    private final LinkedList<Long> executionTimes_ = new LinkedList();

    public EDTProfiler() {
        JFrame frame = new JFrame();
        JButton stop = new JButton("stop");
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EDTProfiler.this.end();
            }
        });
        JButton start = new JButton("start");
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EDTProfiler.this.start();
            }
        });
        frame.setLayout(new GridLayout(2, 1));
        frame.add(start);
        frame.add(stop);
        frame.pack();
        frame.setVisible(true);
    }

    private void start() {
        this.timer_.schedule(this.getTask(), 0L, 100L);
    }

    private void end() {
        this.timer_.cancel();
        for (int i = 0; i < this.startTimes_.size(); ++i) {
            String print = this.startTimes_.get(i) + "\t";
            if (i < this.executionTimes_.size()) {
                print = print + this.executionTimes_.get(i) + "";
            }
            System.out.println(print);
        }
    }

    private TimerTask getTask() {
        return new TimerTask(){

            @Override
            public void run() {
                EDTProfiler.this.startTimes_.add(System.currentTimeMillis());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EDTProfiler.this.executionTimes_.add(System.currentTimeMillis());
                    }
                });
            }
        };
    }
}

