/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.micromanager.utils.ReportingUtils;

public class DirectBuffers {
    public static ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();

    public static ByteBuffer bufferFromBytes(byte[] bytes) {
        return ByteBuffer.allocateDirect(bytes.length).put(bytes);
    }

    public static ShortBuffer bufferFromShorts(short[] shorts) {
        return ByteBuffer.allocateDirect(2 * shorts.length).order(NATIVE_ORDER).asShortBuffer().put(shorts);
    }

    public static IntBuffer bufferFromInts(int[] ints) {
        return ByteBuffer.allocateDirect(4 * ints.length).order(NATIVE_ORDER).asIntBuffer().put(ints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFromBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            byte[] bytes = new byte[buffer.capacity()];
            buffer.rewind();
            buffer.get(bytes);
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short[] shortsFromBuffer(ShortBuffer buffer) {
        ShortBuffer shortBuffer = buffer;
        synchronized (shortBuffer) {
            short[] shorts = new short[buffer.capacity()];
            buffer.rewind();
            buffer.get(shorts);
            return shorts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] intsFromBuffer(IntBuffer buffer) {
        IntBuffer intBuffer = buffer;
        synchronized (intBuffer) {
            int[] ints = new int[buffer.capacity()];
            buffer.rewind();
            buffer.get(ints);
            return ints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object arrayFromBuffer(Buffer buffer) {
        Buffer buffer2 = buffer;
        synchronized (buffer2) {
            if (buffer instanceof ByteBuffer) {
                return DirectBuffers.bytesFromBuffer((ByteBuffer)buffer);
            }
            if (buffer instanceof ShortBuffer) {
                return DirectBuffers.shortsFromBuffer((ShortBuffer)buffer);
            }
            if (buffer instanceof IntBuffer) {
                return DirectBuffers.intsFromBuffer((IntBuffer)buffer);
            }
        }
        return null;
    }

    public static Buffer bufferFromArray(Object primitiveArray) {
        if (primitiveArray instanceof byte[]) {
            return DirectBuffers.bufferFromBytes((byte[])primitiveArray);
        }
        if (primitiveArray instanceof short[]) {
            return DirectBuffers.bufferFromShorts((short[])primitiveArray);
        }
        if (primitiveArray instanceof int[]) {
            return DirectBuffers.bufferFromInts((int[])primitiveArray);
        }
        return null;
    }

    public static ByteBuffer bufferFromString(String string) {
        try {
            return DirectBuffers.bufferFromBytes(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    public static String stringFromBuffer(ByteBuffer byteBuffer) {
        try {
            return new String(DirectBuffers.bytesFromBuffer(byteBuffer), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }
}

