/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.process.ImageProcessor;
import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.api.Autofocus;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public class CoreAutofocus
implements Autofocus {
    private CMMCore core_;
    private String devName_;

    @Override
    public void focus(double coarseStep, int numCoarse, double fineStep, int numFine) throws MMException {
        throw new MMException("Obsolete command. Use setProperty() to specify parameters.");
    }

    @Override
    public double fullFocus() throws MMException {
        if (this.core_ == null) {
            return 0.0;
        }
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.fullFocus();
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
        try {
            return this.core_.getLastFocusScore();
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
            return 0.0;
        }
    }

    @Override
    public String getVerboseStatus() {
        return "No message at this time!";
    }

    @Override
    public double incrementalFocus() throws MMException {
        if (this.core_ == null) {
            return 0.0;
        }
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.incrementalFocus();
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
        try {
            return this.core_.getLastFocusScore();
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return 0.0;
        }
    }

    @Override
    public String[] getPropertyNames() {
        Vector<String> propNames = new Vector<String>();
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            StrVector propNamesVect = this.core_.getDevicePropertyNames(this.devName_);
            int i = 0;
            while ((long)i < propNamesVect.size()) {
                if (!this.core_.isPropertyReadOnly(this.devName_, propNamesVect.get(i)) && !this.core_.isPropertyPreInit(this.devName_, propNamesVect.get(i))) {
                    propNames.add(propNamesVect.get(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        return propNames.toArray(new String[propNames.size()]);
    }

    @Override
    public PropertyItem[] getProperties() {
        Vector<PropertyItem> props = new Vector<PropertyItem>();
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            StrVector propNamesVect = this.core_.getDevicePropertyNames(this.devName_);
            int i = 0;
            while ((long)i < propNamesVect.size()) {
                PropertyItem p = new PropertyItem();
                p.device = this.devName_;
                p.name = propNamesVect.get(i);
                p.value = this.core_.getProperty(this.devName_, p.name);
                p.readOnly = this.core_.isPropertyReadOnly(this.devName_, p.name);
                if (this.core_.hasPropertyLimits(this.devName_, p.name)) {
                    p.lowerLimit = this.core_.getPropertyLowerLimit(this.devName_, p.name);
                    p.upperLimit = this.core_.getPropertyUpperLimit(this.devName_, p.name);
                }
                StrVector vals = this.core_.getAllowedPropertyValues(this.devName_, p.name);
                p.allowed = new String[(int)vals.size()];
                int j = 0;
                while ((long)j < vals.size()) {
                    p.allowed[j] = vals.get(j);
                    ++j;
                }
                props.add(p);
                ++i;
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        return props.toArray(new PropertyItem[0]);
    }

    @Override
    public String getPropertyValue(String name) throws MMException {
        try {
            return this.core_.getProperty(this.devName_, name);
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public PropertyItem getProperty(String name) throws MMException {
        try {
            if (this.core_.hasProperty(this.devName_, name)) {
                PropertyItem p = new PropertyItem();
                p.device = this.devName_;
                p.name = name;
                p.value = this.core_.getProperty(this.devName_, p.name);
                p.readOnly = this.core_.isPropertyReadOnly(this.devName_, p.name);
                if (this.core_.hasPropertyLimits(this.devName_, p.name)) {
                    p.lowerLimit = this.core_.getPropertyLowerLimit(this.devName_, p.name);
                    p.upperLimit = this.core_.getPropertyUpperLimit(this.devName_, p.name);
                }
                StrVector vals = this.core_.getAllowedPropertyValues(this.devName_, p.name);
                p.allowed = new String[(int)vals.size()];
                int j = 0;
                while ((long)j < vals.size()) {
                    p.allowed[j] = vals.get(j);
                    ++j;
                }
                return p;
            }
            throw new MMException("Unknown property: " + name);
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public void setPropertyValue(String name, String value) throws MMException {
        try {
            this.core_.setProperty(this.devName_, name, value);
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public double getCurrentFocusScore() {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return 0.0;
        }
        return this.core_.getCurrentFocusScore();
    }

    @Override
    public void applySettings() {
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public int getNumberOfImages() {
        return this.core_.getRemainingImageCount();
    }

    @Override
    public String getDeviceName() {
        return this.devName_;
    }

    @Override
    public void setProperty(PropertyItem p) throws MMException {
        try {
            this.core_.setProperty(this.devName_, p.name, p.value);
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public void enableContinuousFocus(boolean enable) throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.enableContinuousFocus(enable);
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public boolean isContinuousFocusEnabled() throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            return this.core_.isContinuousFocusEnabled();
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public boolean isContinuousFocusLocked() throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            return this.core_.isContinuousFocusLocked();
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    @Override
    public void setApp(ScriptInterface app) {
        this.core_ = app.getMMCore();
        this.devName_ = this.core_.getAutoFocusDevice();
    }

    @Override
    public double computeScore(ImageProcessor impro) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

