/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ColorRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -2539377758420096159L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public ColorRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        Color newColor = (Color)color;
        if (table.isEnabled()) {
            this.setBackground(newColor);
        } else {
            Color dimColor = this.mixColors(newColor, table.getBackground(), 0.5);
            this.setBackground(dimColor);
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
        return this;
    }

    private Color mixColors(Color fgColor, Color bgColor, double transparency) {
        return new Color((int)((double)fgColor.getRed() * transparency + (double)bgColor.getRed() * (1.0 - transparency)), (int)((double)fgColor.getGreen() * transparency + (double)bgColor.getGreen() * (1.0 - transparency)), (int)((double)fgColor.getBlue() * transparency + (double)bgColor.getBlue() * (1.0 - transparency)));
    }
}

