/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import org.micromanager.utils.ContrastSettings;

public class ChannelSpec {
    public static final String DEFAULT_CHANNEL_GROUP = "Channel";
    public static final double Version = 1.0;
    public Boolean doZStack = true;
    public String config = "";
    public double exposure = 10.0;
    public double zOffset = 0.0;
    public Color color = Color.gray;
    public ContrastSettings contrast = new ContrastSettings(0, 65535);
    public int skipFactorFrame = 0;
    public boolean useChannel = true;
    public String camera = "";

    public ChannelSpec() {
        this.color = Color.WHITE;
    }

    public static String toJSONStream(ChannelSpec cs) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)cs);
    }

    public static ChannelSpec fromJSONStream(String stream) {
        Gson gson = new Gson();
        ChannelSpec cs = (ChannelSpec)gson.fromJson(stream, ChannelSpec.class);
        return cs;
    }

    public static synchronized void main(String[] args) {
        ChannelSpec cs = new ChannelSpec();
        String stream = ChannelSpec.toJSONStream(cs);
        System.out.println("Encoded:\n" + stream);
        ChannelSpec resultCs = ChannelSpec.fromJSONStream(stream);
        System.out.println("Decoded:\n" + ChannelSpec.toJSONStream(resultCs));
    }
}

