/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.gui.ImageCanvas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CanvasPaintPending {
    public static Map<ImageCanvas, List<Object>> requesters_ = new HashMap<ImageCanvas, List<Object>>();

    public static synchronized boolean isMyPaintPending(ImageCanvas canvas, Object caller) {
        if (canvas.getPaintPending()) {
            List<Object> objectList = requesters_.get(canvas);
            if (objectList != null && objectList.contains(caller)) {
                return true;
            }
        } else {
            requesters_.remove(canvas);
        }
        return false;
    }

    public static synchronized void setPaintPending(ImageCanvas canvas, Object caller) {
        canvas.setPaintPending(true);
        List<Object> objectList = requesters_.get(canvas);
        if (objectList == null) {
            objectList = new ArrayList<Object>();
            requesters_.put(canvas, objectList);
        }
        if (!objectList.contains(caller)) {
            objectList.add(caller);
        }
    }

    public static synchronized void removePaintPending(ImageCanvas canvas, Object caller) {
        List<Object> objectList = requesters_.get(canvas);
        if (objectList != null && objectList.contains(caller)) {
            objectList.remove(caller);
            if (objectList.isEmpty()) {
                canvas.setPaintPending(false);
                requesters_.remove(canvas);
            }
        }
    }

    public static synchronized void removeAllPaintPending(ImageCanvas canvas) {
        if (requesters_.containsKey(canvas)) {
            requesters_.remove(canvas);
        }
    }
}

