/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.utils.Calibration;
import org.micromanager.utils.ReportingUtils;

public class CalibrationList {
    private ArrayList<Calibration> calibrationList_ = new ArrayList();
    private String label_ = "Undefined";
    private Hashtable<String, String> properties_ = new Hashtable();
    private CMMCore core_;

    public CalibrationList(CMMCore core) {
        this.core_ = core;
    }

    public void getCalibrationsFromCore() {
        this.calibrationList_.clear();
        StrVector calibrations = this.core_.getAvailablePixelSizeConfigs();
        int i = 0;
        while ((long)i < calibrations.size()) {
            try {
                Calibration cal = new Calibration();
                cal.setConfiguration(this.core_.getPixelSizeConfigData(calibrations.get(i)));
                cal.setLabel(calibrations.get(i));
                cal.setPixelSizeUm(this.core_.getPixelSizeUmByID(calibrations.get(i)));
                this.calibrationList_.add(cal);
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
            ++i;
        }
    }

    public void add(Calibration cl) {
        this.calibrationList_.add(cl);
    }

    public int size() {
        return this.calibrationList_.size();
    }

    public Calibration get(int idx) {
        return this.calibrationList_.get(idx);
    }

    public void setProperty(String key, String value) {
        this.properties_.put(key, value);
    }

    private void handleException(Exception e) {
        String errText = "Exception occurred: " + e.getMessage();
        JOptionPane.showMessageDialog(null, errText);
    }

    public String[] getPropertyNames() {
        String[] keys = new String[this.properties_.size()];
        int i = 0;
        Enumeration<String> e = this.properties_.keys();
        while (e.hasMoreElements()) {
            keys[i++] = e.nextElement();
        }
        return keys;
    }

    public boolean hasProperty(String key) {
        return this.properties_.containsKey(key);
    }

    public String getProperty(String key) {
        if (this.properties_.containsKey(key)) {
            return this.properties_.get(key);
        }
        return null;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String lab) {
        this.label_ = lab;
    }
}

