/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import com.swtdesigner.SwingResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.MMException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SliderPanel;

public class AutofocusPropertyEditor
extends MMDialog {
    private final SpringLayout springLayout;
    private static final long serialVersionUID = 1507097881635431043L;
    private JTable table_;
    private PropertyTableData data_;
    private final PropertyCellEditor cellEditor_;
    private JCheckBox showReadonlyCheckBox_;
    private static final String PREF_SHOW_READONLY = "show_readonly";
    private final JScrollPane scrollPane_;
    private final AutofocusManager afMgr_;
    private final JButton btnClose;
    private JComboBox methodCombo_;

    public AutofocusPropertyEditor(AutofocusManager afmgr) {
        this.afMgr_ = afmgr;
        this.setModal(false);
        this.data_ = new PropertyTableData();
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.data_);
        this.cellEditor_ = new PropertyCellEditor();
        PropertyCellRenderer renderer = new PropertyCellRenderer();
        for (int k = 0; k < this.data_.getColumnCount(); ++k) {
            TableColumn column = new TableColumn(k, 200, renderer, this.cellEditor_);
            this.table_.addColumn(column);
        }
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setSize(551, 514);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AutofocusPropertyEditor.this.cleanup();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                Preferences prefs = AutofocusPropertyEditor.this.getPrefsNode();
                AutofocusPropertyEditor.this.showReadonlyCheckBox_.setSelected(prefs.getBoolean(AutofocusPropertyEditor.PREF_SHOW_READONLY, true));
                AutofocusPropertyEditor.this.data_.updateStatus();
                AutofocusPropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.setTitle("Autofocus properties");
        this.loadAndRestorePosition(100, 100, 400, 300);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.scrollPane_, 70, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.scrollPane_.setViewportView(this.table_);
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        JButton refreshButton = new JButton();
        this.springLayout.putConstraint("North", (Component)refreshButton, 10, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)refreshButton, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)refreshButton, 33, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)refreshButton, 110, "West", (Component)this.getContentPane());
        refreshButton.setIcon(SwingResourceManager.getIcon(AutofocusPropertyEditor.class, "/org/micromanager/icons/arrow_refresh.png"));
        refreshButton.setFont(new Font("Arial", 0, 10));
        this.getContentPane().add(refreshButton);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutofocusPropertyEditor.this.refresh();
            }
        });
        refreshButton.setText("Refresh! ");
        this.showReadonlyCheckBox_ = new JCheckBox();
        this.springLayout.putConstraint("North", (Component)this.showReadonlyCheckBox_, 41, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showReadonlyCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showReadonlyCheckBox_, 64, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.showReadonlyCheckBox_, 183, "West", (Component)this.getContentPane());
        this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
        this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutofocusPropertyEditor.this.data_.setShowReadOnly(AutofocusPropertyEditor.this.showReadonlyCheckBox_.isSelected());
                AutofocusPropertyEditor.this.data_.updateStatus();
                AutofocusPropertyEditor.this.data_.fireTableStructureChanged();
            }
        });
        this.showReadonlyCheckBox_.setText("Show read-only properties");
        this.getContentPane().add(this.showReadonlyCheckBox_);
        Preferences prefs = this.getPrefsNode();
        this.showReadonlyCheckBox_.setSelected(prefs.getBoolean(PREF_SHOW_READONLY, true));
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutofocusPropertyEditor.this.cleanup();
                AutofocusPropertyEditor.this.dispose();
            }
        });
        this.springLayout.putConstraint("South", (Component)this.btnClose, 0, "South", (Component)refreshButton);
        this.springLayout.putConstraint("East", (Component)this.btnClose, -10, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.btnClose);
        if (this.afMgr_ != null) {
            String[] afDevs;
            this.methodCombo_ = new JComboBox();
            for (String devName : afDevs = this.afMgr_.getAfDevices()) {
                this.methodCombo_.addItem(devName);
            }
            if (this.afMgr_.getDevice() != null) {
                this.methodCombo_.setSelectedItem(this.afMgr_.getDevice().getDeviceName());
            }
            this.methodCombo_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutofocusPropertyEditor.this.changeAFMethod((String)AutofocusPropertyEditor.this.methodCombo_.getSelectedItem());
                }
            });
            this.springLayout.putConstraint("West", (Component)this.methodCombo_, 80, "East", (Component)refreshButton);
            this.springLayout.putConstraint("South", (Component)this.methodCombo_, 0, "South", (Component)refreshButton);
            this.springLayout.putConstraint("East", (Component)this.methodCombo_, -6, "West", (Component)this.btnClose);
            this.getContentPane().add(this.methodCombo_);
        }
        this.data_.setShowReadOnly(this.showReadonlyCheckBox_.isSelected());
    }

    protected void changeAFMethod(String focusDev) {
        try {
            this.cellEditor_.stopEditing();
            this.afMgr_.selectDevice(focusDev);
        }
        catch (MMException e) {
            this.handleException(e);
        }
        this.updateStatus();
    }

    protected void refresh() {
        this.data_.refresh();
    }

    public void rebuild() {
        String afDevice = this.afMgr_.getDevice().getDeviceName();
        ActionListener l = this.methodCombo_.getActionListeners()[0];
        try {
            if (l != null) {
                this.methodCombo_.removeActionListener(l);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        this.methodCombo_.removeAllItems();
        if (this.afMgr_ != null) {
            String[] afDevs;
            for (String devName : afDevs = this.afMgr_.getAfDevices()) {
                this.methodCombo_.addItem(devName);
            }
            this.methodCombo_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    AutofocusPropertyEditor.this.changeAFMethod((String)AutofocusPropertyEditor.this.methodCombo_.getSelectedItem());
                }
            });
            if (afDevice != null) {
                this.methodCombo_.setSelectedItem(afDevice);
            } else if (this.afMgr_.getDevice() != null) {
                this.methodCombo_.setSelectedItem(this.afMgr_.getDevice().getDeviceName());
            }
        }
    }

    public void updateStatus() {
        if (this.data_ != null) {
            this.data_.updateStatus();
        }
    }

    private void handleException(Exception e) {
        ReportingUtils.showError(e);
    }

    public void cleanup() {
        this.getPrefsNode().putBoolean(PREF_SHOW_READONLY, this.showReadonlyCheckBox_.isSelected());
        if (this.afMgr_ != null && this.afMgr_.getDevice() != null) {
            this.afMgr_.getDevice().applySettings();
            this.afMgr_.getDevice().saveSettings();
        }
    }

    public class PropertyCellRenderer
    implements TableCellRenderer {
        PropertyItem item_;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            JComponent comp;
            PropertyTableData data = (PropertyTableData)table.getModel();
            this.item_ = data.getPropertyItem(rowIndex);
            if (isSelected) {
                // empty if block
            }
            if (hasFocus) {
                // empty if block
            }
            if (colIndex == 0) {
                JLabel lab = new JLabel();
                lab.setText((String)value);
                lab.setOpaque(true);
                lab.setHorizontalAlignment(2);
                comp = lab;
            } else if (colIndex == 1) {
                if (this.item_.hasRange) {
                    SliderPanel slider = new SliderPanel();
                    slider.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                    try {
                        slider.setText((String)value);
                    }
                    catch (ParseException ex) {
                        ReportingUtils.logError(ex);
                    }
                    slider.setToolTipText((String)value);
                    comp = slider;
                } else {
                    JLabel lab = new JLabel();
                    lab.setOpaque(true);
                    lab.setText(this.item_.value);
                    lab.setHorizontalAlignment(2);
                    comp = lab;
                }
            } else {
                comp = new JLabel("Undefinded");
            }
            if (this.item_.readOnly) {
                ((Component)comp).setBackground(Color.LIGHT_GRAY);
            } else {
                ((Component)comp).setBackground(Color.white);
            }
            return comp;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTextField text_ = new JTextField();
        JComboBox combo_ = new JComboBox();
        JCheckBox check_ = new JCheckBox();
        SliderPanel slider_ = new SliderPanel();
        int editingCol_;
        PropertyItem item_;

        public PropertyCellEditor() {
            this.check_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addEditActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addSliderMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
        }

        public void stopEditing() {
            this.fireEditingStopped();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            if (isSelected) {
                // empty if block
            }
            this.editingCol_ = colIndex;
            PropertyTableData data = (PropertyTableData)table.getModel();
            this.item_ = data.getPropertyItem(rowIndex);
            if (colIndex == 1) {
                int i;
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        if (this.item_.isInteger()) {
                            this.slider_.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                        } else {
                            this.slider_.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                        }
                        try {
                            this.slider_.setText((String)value);
                        }
                        catch (ParseException ex) {
                            ReportingUtils.logError(ex);
                        }
                        return this.slider_;
                    }
                    this.text_.setText((String)value);
                    return this.text_;
                }
                ActionListener[] l = this.combo_.getActionListeners();
                for (i = 0; i < l.length; ++i) {
                    this.combo_.removeActionListener(l[i]);
                }
                this.combo_.removeAllItems();
                for (i = 0; i < this.item_.allowed.length; ++i) {
                    this.combo_.addItem(this.item_.allowed[i]);
                }
                this.combo_.setSelectedItem(this.item_.value);
                this.combo_.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropertyCellEditor.this.fireEditingStopped();
                    }
                });
                return this.combo_;
            }
            if (colIndex == 2) {
                return this.check_;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editingCol_ == 1) {
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        return this.slider_.getText();
                    }
                    return this.text_.getText();
                }
                return this.combo_.getSelectedItem();
            }
            if (this.editingCol_ == 2) {
                return this.check_;
            }
            return null;
        }
    }

    final class PropertyTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] columnNames_ = new String[]{"Property", "Value"};
        ArrayList<PropertyItem> propList_ = new ArrayList();
        private boolean showReadOnly_ = true;

        public PropertyTableData() {
            this.updateStatus();
        }

        public void setShowReadOnly(boolean show) {
            this.showReadOnly_ = show;
        }

        @Override
        public int getRowCount() {
            return this.propList_.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames_.length;
        }

        public PropertyItem getPropertyItem(int row) {
            return this.propList_.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropertyItem item = this.propList_.get(row);
            if (col == 0) {
                return item.device + "-" + item.name;
            }
            if (col == 1) {
                return item.value;
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PropertyItem item = this.propList_.get(row);
            if (col == 1 && AutofocusPropertyEditor.this.afMgr_.getDevice() != null) {
                try {
                    if (item.isInteger()) {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(item.name, NumberUtils.intStringDisplayToCore(value));
                    } else if (item.isFloat()) {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(item.name, NumberUtils.doubleStringDisplayToCore(value));
                    } else {
                        AutofocusPropertyEditor.this.afMgr_.getDevice().setPropertyValue(item.name, value.toString());
                    }
                    this.refresh();
                    this.fireTableCellUpdated(row, col);
                }
                catch (ParseException e) {
                    AutofocusPropertyEditor.this.handleException(e);
                }
                catch (MMException e) {
                    AutofocusPropertyEditor.this.handleException(e);
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames_[column];
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            if (nCol == 1) {
                return !this.propList_.get((int)nRow).readOnly;
            }
            return false;
        }

        public void refresh() {
            if (AutofocusPropertyEditor.this.afMgr_.getDevice() == null) {
                return;
            }
            try {
                for (int i = 0; i < this.propList_.size(); ++i) {
                    PropertyItem item = this.propList_.get(i);
                    item.value = AutofocusPropertyEditor.this.afMgr_.getDevice().getPropertyValue(item.name);
                }
                this.fireTableDataChanged();
            }
            catch (MMException e) {
                AutofocusPropertyEditor.this.handleException(e);
            }
        }

        public void updateStatus() {
            this.propList_.clear();
            PropertyItem[] properties = new PropertyItem[]{};
            if (AutofocusPropertyEditor.this.afMgr_.getDevice() != null) {
                properties = AutofocusPropertyEditor.this.afMgr_.getDevice().getProperties();
            }
            for (int j = 0; j < properties.length; ++j) {
                if (properties[j].preInit || (!this.showReadOnly_ || !properties[j].readOnly) && properties[j].readOnly) continue;
                this.propList_.add(properties[j]);
            }
            this.fireTableStructureChanged();
        }

        public boolean isShowReadOnly() {
            return this.showReadOnly_;
        }
    }
}

