/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import org.micromanager.api.Autofocus;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.AutofocusPropertyEditor;
import org.micromanager.utils.CoreAutofocus;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

public class AutofocusManager {
    private ScriptInterface app_;
    private Vector<Autofocus> afs_ = new Vector();
    private Vector<String> afPluginClassNames_ = new Vector();
    private Autofocus currentAfDevice_ = null;
    private AutofocusPropertyEditor afDlg_;

    public AutofocusManager(ScriptInterface app) {
        this.app_ = app;
    }

    public void selectDevice(String name) throws MMException {
        for (Autofocus af : this.afs_) {
            if (!af.getDeviceName().equals(name)) continue;
            this.currentAfDevice_ = af;
            return;
        }
        throw new MMException(name + " not loaded.");
    }

    public void setAFPluginClassName(String className) {
        if (!this.afPluginClassNames_.contains(className)) {
            this.afPluginClassNames_.add(className);
        }
    }

    public Autofocus getDevice() {
        return this.currentAfDevice_;
    }

    public void refresh() throws MMException {
        this.afs_.clear();
        CMMCore core = this.app_.getMMCore();
        StrVector afDevs = core.getLoadedDevicesOfType(DeviceType.AutoFocusDevice);
        int i = 0;
        while ((long)i < afDevs.size()) {
            CoreAutofocus caf = new CoreAutofocus();
            try {
                core.setAutoFocusDevice(afDevs.get(i));
                caf.setApp(this.app_);
                if (caf.getDeviceName().length() != 0) {
                    this.afs_.add(caf);
                    if (this.currentAfDevice_ == null) {
                        this.currentAfDevice_ = caf;
                    }
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
            ++i;
        }
        try {
            for (i = 0; i < this.afPluginClassNames_.size(); ++i) {
                String name = this.afPluginClassNames_.get(i);
                if (name.length() == 0) continue;
                Autofocus jaf = null;
                try {
                    jaf = this.loadAutofocusPlugin(name);
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                    this.afPluginClassNames_.remove(name);
                    --i;
                }
                if (jaf == null) continue;
                this.afs_.add(jaf);
                if (this.currentAfDevice_ == null) {
                    this.currentAfDevice_ = jaf;
                }
                jaf.setApp(this.app_);
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
        boolean found = false;
        for (Autofocus af : this.afs_) {
            if (!af.getDeviceName().equals(this.currentAfDevice_.getDeviceName())) continue;
            found = true;
            this.currentAfDevice_ = af;
        }
        if (!found && this.afs_.size() > 0) {
            this.currentAfDevice_ = this.afs_.get(0);
        }
        if (this.afDlg_ != null) {
            this.afDlg_.rebuild();
        }
    }

    public void showOptionsDialog() {
        if (this.afDlg_ == null) {
            this.afDlg_ = new AutofocusPropertyEditor(this);
        }
        this.afDlg_.setVisible(true);
        if (this.currentAfDevice_ != null) {
            this.currentAfDevice_.applySettings();
            this.currentAfDevice_.saveSettings();
        }
    }

    public void closeOptionsDialog() {
        if (this.afDlg_ != null) {
            this.afDlg_.cleanup();
        }
    }

    public String[] getAfDevices() {
        String[] afDevs = new String[this.afs_.size()];
        int count = 0;
        for (Autofocus af : this.afs_) {
            afDevs[count++] = af.getDeviceName();
        }
        return afDevs;
    }

    private Autofocus loadAutofocusPlugin(String className) throws MMException {
        String msg = new String(className + " module.");
        Autofocus af = null;
        try {
            Class<?> cl = Class.forName(className);
            af = (Autofocus)cl.newInstance();
            return af;
        }
        catch (ClassNotFoundException e) {
            ReportingUtils.logError(e);
            msg = className + " autofocus plugin not found.";
        }
        catch (InstantiationException e) {
            ReportingUtils.logError(e);
            msg = className + " instantiation to Autofocus interface failed.";
        }
        catch (IllegalAccessException e) {
            ReportingUtils.logError(e);
            msg = "Illegal access exception!";
        }
        catch (NoClassDefFoundError e) {
            ReportingUtils.logError(e);
            msg = className + " class definition nor found.";
        }
        ReportingUtils.logMessage(msg);
        throw new MMException(msg);
    }

    public boolean hasDevice(String dev) {
        for (Autofocus af : this.afs_) {
            if (!af.getDeviceName().equals(dev)) continue;
            return true;
        }
        return false;
    }
}

