/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.micromanager.api.Autofocus;
import org.micromanager.utils.MMException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public abstract class AutofocusBase
implements Autofocus {
    private ArrayList<PropertyItem> properties_;
    protected final Preferences prefs_;
    private static final String AF_UNIMPLEMENTED_FUNCTION = "Operation not supported.";

    public AutofocusBase() {
        Preferences root = Preferences.userNodeForPackage(AutofocusBase.class);
        this.prefs_ = root.node(root.absolutePath() + "/autofocus_plugin_settings/" + this.getClass().getCanonicalName());
        this.properties_ = new ArrayList();
    }

    protected void createProperty(String name) {
        PropertyItem p = new PropertyItem();
        p.name = name;
        p.device = this.getDeviceName();
        this.properties_.add(p);
    }

    protected void createProperty(String name, String value) {
        PropertyItem p = new PropertyItem();
        p.name = name;
        p.value = value;
        p.device = this.getDeviceName();
        this.properties_.add(p);
    }

    protected void createProperty(String name, String value, String[] allowed) {
        PropertyItem p = new PropertyItem();
        p.allowed = allowed;
        p.name = name;
        p.value = value;
        p.device = this.getDeviceName();
        this.properties_.add(p);
    }

    protected void addProperty(PropertyItem p) {
        this.properties_.add(p);
    }

    @Override
    public String[] getPropertyNames() {
        String[] propName = new String[this.properties_.size()];
        for (int i = 0; i < this.properties_.size(); ++i) {
            propName[i] = this.properties_.get((int)i).name;
        }
        return propName;
    }

    @Override
    public String getPropertyValue(String name) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!name.equals(this.properties_.get((int)i).name)) continue;
            return this.properties_.get((int)i).value;
        }
        throw new MMException("Unknown property: " + name);
    }

    @Override
    public PropertyItem getProperty(String name) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!name.equals(this.properties_.get((int)i).name)) continue;
            return this.properties_.get(i);
        }
        throw new MMException("Unknown property: " + name);
    }

    @Override
    public void setProperty(PropertyItem p) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!p.name.equals(this.properties_.get((int)i).name)) continue;
            this.properties_.set(i, p);
            return;
        }
        this.properties_.add(p);
    }

    @Override
    public void setPropertyValue(String name, String value) throws MMException {
        for (int i = 0; i < this.properties_.size(); ++i) {
            if (!name.equals(this.properties_.get((int)i).name)) continue;
            this.properties_.get((int)i).value = value;
            return;
        }
        throw new MMException("Unknown property: " + name);
    }

    @Override
    public PropertyItem[] getProperties() {
        return this.properties_.toArray(new PropertyItem[this.properties_.size()]);
    }

    @Override
    public void saveSettings() {
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.prefs_.put(this.properties_.get((int)i).name, this.properties_.get((int)i).value);
        }
    }

    public void loadSettings() {
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.properties_.get((int)i).value = this.prefs_.get(this.properties_.get((int)i).name, this.properties_.get((int)i).value);
        }
    }

    public void dumpProperties(String msg) {
        ReportingUtils.logMessage(msg);
        for (int i = 0; i < this.properties_.size(); ++i) {
            this.properties_.get(i).dump();
        }
    }

    @Override
    public void enableContinuousFocus(boolean enable) throws MMException {
        throw new MMException(AF_UNIMPLEMENTED_FUNCTION);
    }

    @Override
    public boolean isContinuousFocusEnabled() throws MMException {
        return false;
    }

    @Override
    public boolean isContinuousFocusLocked() throws MMException {
        return false;
    }
}

