/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

public class AcqOrderMode {
    public static final int TIME_POS_SLICE_CHANNEL = 0;
    public static final int TIME_POS_CHANNEL_SLICE = 1;
    public static final int POS_TIME_SLICE_CHANNEL = 2;
    public static final int POS_TIME_CHANNEL_SLICE = 3;
    private int id_;
    private boolean timeEnabled_;
    private boolean posEnabled_;
    private boolean sliceEnabled_;
    private boolean channelEnabled_;

    public AcqOrderMode(int id) {
        this.id_ = id;
        this.timeEnabled_ = true;
        this.posEnabled_ = true;
        this.sliceEnabled_ = true;
        this.channelEnabled_ = true;
    }

    public String toString() {
        StringBuffer name = new StringBuffer();
        if (this.timeEnabled_ && this.posEnabled_) {
            if (this.id_ == 1 || this.id_ == 0) {
                name.append("Time, Position");
            } else {
                name.append("Position, Time");
            }
        } else if (this.timeEnabled_) {
            name.append("Time");
        } else if (this.posEnabled_) {
            name.append("Position");
        }
        if ((this.timeEnabled_ || this.posEnabled_) && (this.channelEnabled_ || this.sliceEnabled_)) {
            name.append(", ");
        }
        if (this.channelEnabled_ && this.sliceEnabled_) {
            if (this.id_ == 1 || this.id_ == 3) {
                name.append("Channel, Slice");
            } else {
                name.append("Slice, Channel");
            }
        } else if (this.channelEnabled_) {
            name.append("Channel");
        } else if (this.sliceEnabled_) {
            name.append("Slice");
        }
        return name.toString();
    }

    public void setEnabled(boolean time, boolean position, boolean slice, boolean channel) {
        this.timeEnabled_ = time;
        this.posEnabled_ = position;
        this.sliceEnabled_ = slice;
        this.channelEnabled_ = channel;
    }

    public int getID() {
        return this.id_;
    }
}

