/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.script;

import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.util.JConsole;
import com.swtdesigner.SwingResourceManager;
import ij.plugin.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import mmcorej.CMMCore;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.micromanager.MMStudio;
import org.micromanager.PropertyEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.script.BeanshellEngine;
import org.micromanager.script.ScriptingEngine;
import org.micromanager.script.ScriptingGUI;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeysDialog;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TooltipTextMaker;

public final class ScriptPanel
extends MMFrame
implements MouseListener,
ScriptingGUI {
    private static final long serialVersionUID = 1L;
    private static final int HISTORYSIZE = 100;
    private JTable scriptTable_;
    private static ScriptTableModel model_;
    private final RSyntaxTextArea scriptArea_;
    private final RTextScrollPane sp;
    private boolean scriptPaneSaved_;
    private File scriptFile_;
    private JTextField immediatePane_;
    private JSplitPane rightSplitPane_;
    private JSplitPane splitPane_;
    private JButton runButton_;
    private JButton stopButton_;
    private List<String> immediatePaneHistory_ = new ArrayList<String>(100);
    private int immediatePaneHistoryIndex_ = 0;
    private Preferences prefs_;
    private static ScriptingEngine interp_;
    private ScriptInterface parentGUI_;
    private JTextPane messagePane_;
    private StyleContext sc_;
    private Interpreter beanshellREPLint_;
    private JConsole cons_;
    private static final FileDialogs.FileType BSH_FILE;
    private static final String SCRIPT_FILE = "script_file_";
    private static final String RIGHT_DIVIDER_LOCATION = "right_divider_location";
    private static final String DIVIDER_LOCATION = "divider_location";
    private static final String EXT_POS = "bsh";
    private static final String EXT_ACQ = "xml";
    private static final String APP_NAME = "MMScriptPanel";
    private static final String blackStyleName_ = "blackStyle";
    private static final String redStyleName_ = "Red";
    private final MMStudio gui_;

    public final void createBeanshellREPL() {
        this.cons_ = new JConsole();
        this.beanshellREPLint_ = new Interpreter((ConsoleInterface)this.cons_);
        File tmpFile = null;
        try {
            InputStream input = this.getClass().getResourceAsStream("/org/micromanager/scriptpanel/scriptpanel_startup.bsh");
            if (input != null) {
                int read;
                tmpFile = File.createTempFile("mm_scriptpanel_startup", ".bsh");
                FileOutputStream output = new FileOutputStream(tmpFile);
                byte[] bytes = new byte[4096];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)output).write(bytes, 0, read);
                }
                ((OutputStream)output).close();
                tmpFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            ReportingUtils.showError("Failed to read Script Panel BeanShell startup script", (Component)this);
        }
        if (tmpFile != null) {
            try {
                this.beanshellREPLint_.source(tmpFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                ReportingUtils.showError((Throwable)e, (Component)this);
            }
            catch (IOException e) {
                ReportingUtils.showError((Throwable)e, (Component)this);
            }
            catch (EvalError e) {
                ReportingUtils.showError((Throwable)e, (Component)this);
            }
        }
        this.beanshellREPLint_.setShowResults(true);
        new Thread((Runnable)this.beanshellREPLint_, "BeanShell interpreter").start();
    }

    public JConsole getREPLCons() {
        return this.cons_;
    }

    private void readFileToTextArea(File file, RSyntaxTextArea rsa) throws FileNotFoundException, IOException, MMScriptException {
        FileReader in = new FileReader(file);
        rsa.setRows(1);
        rsa.read((Reader)in, null);
        rsa.setCaretPosition(0);
    }

    public ScriptPanel(CMMCore core, MMStudio gui) {
        this.gui_ = gui;
        final ScriptPanel scriptPanelFrame = this;
        this.createBeanshellREPL();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (!ScriptPanel.this.promptToSave(-1)) {
                    return;
                }
                ScriptPanel.this.prefs_.putInt(ScriptPanel.RIGHT_DIVIDER_LOCATION, ScriptPanel.this.rightSplitPane_.getDividerLocation());
                ScriptPanel.this.prefs_.putInt(ScriptPanel.DIVIDER_LOCATION, ScriptPanel.this.splitPane_.getDividerLocation());
                ScriptPanel.this.saveScriptsToPrefs();
                ScriptPanel.this.setVisible(false);
            }
        });
        this.setVisible(false);
        interp_ = new BeanshellEngine(this);
        interp_.setInterpreter(this.beanshellREPLint_);
        this.setTitle("Script Panel");
        this.setIconImage(SwingResourceManager.getImage(PropertyEditor.class, "icons/microscope.gif"));
        int buttonHeight = 15;
        Dimension buttonSize = new Dimension(80, buttonHeight);
        int gap = 5;
        this.prefs_ = this.getPrefsNode();
        this.loadAndRestorePosition(100, 100, 550, 495);
        JPanel leftPanel = new JPanel();
        SpringLayout spLeft = new SpringLayout();
        leftPanel.setLayout(spLeft);
        JPanel topRightPanel = new JPanel();
        SpringLayout spTopRight = new SpringLayout();
        topRightPanel.setLayout(spTopRight);
        JPanel bottomRightPanel = new JPanel();
        bottomRightPanel.setLayout(new BoxLayout(bottomRightPanel, 1));
        bottomRightPanel.setBackground(Color.white);
        JButton addButton = new JButton();
        addButton.setFont(new Font("", 0, 10));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.addScript();
            }
        });
        addButton.setText("Add");
        addButton.setToolTipText("Add shortcut to beanshell script in file system");
        addButton.setPreferredSize(buttonSize);
        spLeft.putConstraint("North", (Component)addButton, gap, "North", (Component)leftPanel);
        spLeft.putConstraint("West", (Component)addButton, gap, "West", (Component)leftPanel);
        leftPanel.add(addButton);
        JButton removeButton = new JButton();
        removeButton.setMargin(new Insets(0, 0, 0, 0));
        removeButton.setFont(new Font("", 0, 10));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.removeScript();
            }
        });
        removeButton.setText("Remove");
        removeButton.setToolTipText("Remove currently selected shortcut");
        removeButton.setPreferredSize(buttonSize);
        spLeft.putConstraint("North", (Component)removeButton, gap, "North", (Component)leftPanel);
        spLeft.putConstraint("West", (Component)removeButton, gap, "East", (Component)addButton);
        leftPanel.add(removeButton);
        JButton hotkeyButton = new JButton();
        hotkeyButton.setMargin(new Insets(0, 0, 0, 0));
        hotkeyButton.setFont(new Font("", 0, 10));
        hotkeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HotKeysDialog hk = new HotKeysDialog();
            }
        });
        hotkeyButton.setText("ShortCuts");
        hotkeyButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Opens shortcuts manager window.  Allows the creation of keyboard shortcuts to automatically run scripts"));
        hotkeyButton.setPreferredSize(buttonSize);
        spLeft.putConstraint("North", (Component)hotkeyButton, gap, "North", (Component)leftPanel);
        spLeft.putConstraint("West", (Component)hotkeyButton, gap, "East", (Component)removeButton);
        leftPanel.add(hotkeyButton);
        JScrollPane scrollPane = new JScrollPane();
        leftPanel.add(scrollPane);
        spLeft.putConstraint("East", (Component)scrollPane, 0, "East", (Component)leftPanel);
        spLeft.putConstraint("South", (Component)scrollPane, -gap, "South", (Component)leftPanel);
        spLeft.putConstraint("West", (Component)scrollPane, gap, "West", (Component)leftPanel);
        spLeft.putConstraint("North", (Component)scrollPane, gap, "South", (Component)removeButton);
        this.scriptArea_ = new RSyntaxTextArea(1, 20);
        this.scriptArea_.setSyntaxEditingStyle("text/java");
        this.scriptArea_.setCodeFoldingEnabled(true);
        this.scriptArea_.setAutoIndentEnabled(true);
        this.scriptArea_.getDocument().putProperty("tabSize", 3);
        this.scriptArea_.setBackground(Color.WHITE);
        this.scriptArea_.getDocument().addDocumentListener(new MyDocumentListener());
        this.scriptArea_.setMinimumSize(new Dimension(300, 300));
        this.scriptArea_.setMaximumSize(new Dimension(800, 800));
        this.scriptArea_.setPreferredSize(new Dimension(800, 300));
        this.scriptPaneSaved_ = true;
        this.scriptArea_.setFocusTraversalKeysEnabled(false);
        this.sp = new RTextScrollPane((Component)this.scriptArea_);
        this.sp.setFocusTraversalKeysEnabled(false);
        this.sp.setLineNumbersEnabled(true);
        spTopRight.putConstraint("East", (Component)this.sp, 0, "East", (Component)topRightPanel);
        spTopRight.putConstraint("South", (Component)this.sp, -(buttonHeight + 2 * gap), "South", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)this.sp, 0, "West", (Component)topRightPanel);
        spTopRight.putConstraint("North", (Component)this.sp, buttonHeight + 2 * gap, "North", (Component)topRightPanel);
        topRightPanel.add((Component)this.sp);
        bottomRightPanel.add((Component)this.cons_);
        this.immediatePane_ = new JTextField();
        this.immediatePane_.setFont(new Font("Courier New", 0, 12));
        this.immediatePane_.setBackground(Color.WHITE);
        this.immediatePane_.addActionListener(new immediatePaneListener());
        this.immediatePane_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    ScriptPanel.this.doImmediatePaneHistoryUp();
                } else if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    ScriptPanel.this.doImmediatePaneHistoryDown();
                }
            }
        });
        this.immediatePane_.setMinimumSize(new Dimension(100, 15));
        this.immediatePane_.setMaximumSize(new Dimension(2000, 15));
        this.messagePane_ = new JTextPane();
        this.messagePane_.setFont(new Font("Courier New", 0, 12));
        this.messagePane_.setBackground(Color.WHITE);
        JScrollPane messageScrollPane = new JScrollPane(this.messagePane_);
        messageScrollPane.setMinimumSize(new Dimension(100, 30));
        messageScrollPane.setMaximumSize(new Dimension(2000, 2000));
        this.sc_ = new StyleContext();
        Style blackStyle_ = this.messagePane_.getLogicalStyle();
        blackStyle_ = this.sc_.addStyle(blackStyleName_, blackStyle_);
        StyleConstants.setForeground(blackStyle_, Color.black);
        Style redStyle_ = this.sc_.addStyle(redStyleName_, null);
        StyleConstants.setForeground(redStyle_, Color.red);
        this.messagePane_.setKeymap(null);
        this.scriptTable_ = new JTable();
        this.scriptTable_.setFont(new Font("", 0, 12));
        model_ = new ScriptTableModel();
        this.scriptTable_.setModel(model_);
        this.scriptTable_.setCellSelectionEnabled(true);
        this.scriptTable_.setSelectionMode(0);
        SelectionListener listener = new SelectionListener(this.scriptTable_);
        this.scriptTable_.getSelectionModel().addListSelectionListener(listener);
        this.scriptTable_.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        InputMap im = this.scriptTable_.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), "none");
        scrollPane.setViewportView(this.scriptTable_);
        this.scriptTable_.addMouseListener(this);
        this.runButton_ = new JButton();
        topRightPanel.add(this.runButton_);
        this.runButton_.setFont(new Font("", 0, 10));
        this.runButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.runPane();
            }
        });
        this.runButton_.setText("Run");
        this.runButton_.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)this.runButton_, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)this.runButton_, gap, "West", (Component)topRightPanel);
        this.stopButton_ = new JButton();
        topRightPanel.add(this.stopButton_);
        this.stopButton_.setFont(new Font("", 0, 10));
        this.stopButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.stopScript("Interrupt".equals(ScriptPanel.this.stopButton_.getText()));
            }
        });
        this.stopButton_.setText("Interrupt");
        this.stopButton_.setEnabled(false);
        this.stopButton_.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)this.stopButton_, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)this.stopButton_, gap, "East", (Component)this.runButton_);
        JButton newButton = new JButton();
        topRightPanel.add(newButton);
        newButton.setFont(new Font("", 0, 10));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.newPane();
            }
        });
        newButton.setText("New");
        newButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)newButton, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)newButton, gap, "East", (Component)this.stopButton_);
        JButton openButton = new JButton();
        topRightPanel.add(openButton);
        openButton.setFont(new Font("", 0, 10));
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.openScriptInPane();
            }
        });
        openButton.setText("Open");
        openButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)openButton, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)openButton, gap, "East", (Component)newButton);
        JButton saveButton = new JButton();
        topRightPanel.add(saveButton);
        saveButton.setFont(new Font("", 0, 10));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.saveScript(-1);
            }
        });
        saveButton.setText("Save");
        saveButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)saveButton, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)saveButton, gap, "East", (Component)openButton);
        JButton saveAsButton = new JButton();
        saveAsButton.setMargin(new Insets(0, 0, 0, 0));
        topRightPanel.add(saveAsButton);
        saveAsButton.setFont(new Font("", 0, 10));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.saveScriptAs();
            }
        });
        saveAsButton.setText("Save As");
        saveAsButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)saveAsButton, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)saveAsButton, gap, "East", (Component)saveButton);
        JButton helpButton = new JButton();
        helpButton.setMargin(new Insets(0, 0, 0, 0));
        topRightPanel.add(helpButton);
        helpButton.setFont(new Font("", 0, 10));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL((String)"https://micro-manager.org/wiki/Script_Panel_GUI");
                }
                catch (IOException e1) {
                    ReportingUtils.showError((Throwable)e1, (Component)scriptPanelFrame);
                }
            }
        });
        helpButton.setText("Help");
        helpButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("North", (Component)helpButton, gap, "North", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)helpButton, gap, "East", (Component)saveAsButton);
        JLabel fLabel = new JLabel("Find:");
        topRightPanel.add(fLabel);
        fLabel.setFont(new Font("", 0, 10));
        spTopRight.putConstraint("South", (Component)fLabel, -gap, "South", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)fLabel, gap, "West", (Component)topRightPanel);
        final JTextField findTextField = new JTextField(20);
        topRightPanel.add(findTextField);
        findTextField.setFont(new Font("", 0, 10));
        spTopRight.putConstraint("South", (Component)findTextField, 0, "South", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)findTextField, gap, "East", (Component)fLabel);
        final SearchContext context = new SearchContext();
        JButton findButton = new JButton();
        topRightPanel.add(findButton);
        findButton.setFont(new Font("", 0, 10));
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.find(context, findTextField.getText(), false);
            }
        });
        findButton.setText("Find Next");
        findButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("South", (Component)findButton, -gap, "South", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)findButton, gap, "East", (Component)findTextField);
        JButton findRevButton = new JButton();
        topRightPanel.add(findRevButton);
        findRevButton.setFont(new Font("", 0, 10));
        findRevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScriptPanel.this.find(context, findTextField.getText(), true);
            }
        });
        findRevButton.setText("Find Previous");
        findRevButton.setPreferredSize(buttonSize);
        spTopRight.putConstraint("South", (Component)findRevButton, -gap, "South", (Component)topRightPanel);
        spTopRight.putConstraint("West", (Component)findRevButton, gap, "East", (Component)findButton);
        leftPanel.setMinimumSize(new Dimension(180, 130));
        this.rightSplitPane_ = new JSplitPane(0, topRightPanel, bottomRightPanel);
        this.rightSplitPane_.setOneTouchExpandable(true);
        int rightDividerLocation = this.prefs_.getInt(RIGHT_DIVIDER_LOCATION, 200);
        this.rightSplitPane_.setDividerLocation(rightDividerLocation);
        this.splitPane_ = new JSplitPane(1, leftPanel, this.rightSplitPane_);
        this.splitPane_.setOneTouchExpandable(true);
        int dividerLocation = this.prefs_.getInt(DIVIDER_LOCATION, 200);
        this.splitPane_.setDividerLocation(dividerLocation);
        this.splitPane_.setMinimumSize(new Dimension(180, 130));
        this.rightSplitPane_.setResizeWeight(1.0);
        this.splitPane_.setResizeWeight(0.0);
        this.getContentPane().add(this.splitPane_);
        this.getScriptsFromPrefs();
    }

    protected void stopScript(boolean shouldInterrupt) {
        interp_.stopRequest(shouldInterrupt);
        this.stopButton_.setText("Terminate");
    }

    private void find(SearchContext context, String text, boolean reverse) {
        if (text.length() == 0) {
            return;
        }
        context.setSearchFor(text);
        context.setMatchCase(false);
        context.setRegularExpression(false);
        context.setSearchForward(!reverse);
        context.setWholeWord(false);
        SearchResult found = SearchEngine.find((JTextArea)this.scriptArea_, (SearchContext)context);
        if (!found.wasFound()) {
            this.gui_.showMessage("\"" + text + "\" was not found", this);
        }
    }

    public boolean promptToSave(int row) {
        if (this.scriptPaneSaved_) {
            return true;
        }
        String message = this.scriptFile_ != null ? "Save changes to " + this.scriptFile_.getName() + "?" : "Save script?";
        int result = JOptionPane.showConfirmDialog(this, message, APP_NAME, 0, 1);
        switch (result) {
            case 0: {
                this.saveScript(row);
                break;
            }
            case 1: {
                this.scriptPaneSaved_ = true;
            }
        }
        return true;
    }

    private void addScript() {
        if (this.scriptFile_ != null && !model_.HasScriptAlready(this.scriptFile_).booleanValue()) {
            this.addScriptToModel(this.scriptFile_);
        } else if (this.scriptFile_ == null && !this.scriptPaneSaved_) {
            if (!this.promptToSave(-1)) {
                return;
            }
            this.addScriptToModel(this.scriptFile_);
        } else {
            if (!this.promptToSave(-1)) {
                return;
            }
            File curFile = FileDialogs.openFile(this, "Select a Beanshell script", BSH_FILE);
            if (curFile != null) {
                this.prefs_.put(SCRIPT_FILE, curFile.getAbsolutePath());
                this.addScriptToModel(curFile);
            }
        }
    }

    private void addScriptToModel(File curFile) {
        model_.AddScript(curFile);
        model_.fireTableDataChanged();
        int[] cellAddress = new int[2];
        model_.GetCell(curFile, cellAddress);
        this.scriptTable_.changeSelection(cellAddress[0], cellAddress[1], false, false);
    }

    private void removeScript() {
        if (!this.promptToSave(-1)) {
            return;
        }
        model_.RemoveScript(this.scriptTable_.getSelectedRow(), this.scriptTable_.getSelectedColumn());
        model_.fireTableDataChanged();
        this.scriptArea_.setText("");
        this.scriptPaneSaved_ = true;
        this.setTitle("");
        this.scriptFile_ = null;
    }

    private void saveScript(int row) {
        if (this.scriptFile_ == null) {
            this.saveScriptAs();
            return;
        }
        if (this.scriptFile_ != null && this.scriptTable_.getSelectedRow() > -1) {
            boolean modified;
            if (row < 0) {
                row = this.scriptTable_.getSelectedRow();
            }
            boolean bl = modified = this.scriptFile_.lastModified() != model_.getLastMod(row, 0).longValue();
            if (modified) {
                int result = JOptionPane.showConfirmDialog(this, "Script was changed on disk.  Continue saving anyways?", APP_NAME, 0, 1);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }
        try {
            FileWriter fw = new FileWriter(this.scriptFile_);
            fw.write(this.scriptArea_.getText());
            fw.close();
            this.scriptPaneSaved_ = true;
            int[] cellAddress = new int[2];
            model_.GetCell(this.scriptFile_, cellAddress);
            model_.setLastMod(cellAddress[0], 0, this.scriptFile_.lastModified());
            this.gui_.message("Saved file: " + this.scriptFile_.getName());
        }
        catch (IOException ioe) {
            ReportingUtils.showError((Throwable)ioe, (Component)this);
        }
        catch (MMScriptException mex) {
            ReportingUtils.logError(mex);
        }
    }

    private void saveScriptAs() {
        File saveFile = FileDialogs.save(this, "Save beanshell script", BSH_FILE);
        if (saveFile != null) {
            try {
                String fileName = saveFile.getName();
                if (fileName.length() < 5 || fileName.charAt(fileName.length() - 4) != '.' && fileName.charAt(fileName.length() - 5) != '.') {
                    fileName = fileName + ".bsh";
                }
                saveFile = new File(saveFile.getParentFile(), fileName);
                FileWriter fw = new FileWriter(saveFile);
                fw.write(this.scriptArea_.getText());
                fw.close();
                this.scriptFile_ = saveFile;
                this.prefs_.put(SCRIPT_FILE, saveFile.getAbsolutePath());
                this.scriptPaneSaved_ = true;
                this.setTitle(saveFile.getName());
            }
            catch (IOException ioe) {
                ReportingUtils.showError((Throwable)ioe, (Component)this);
            }
        }
    }

    private void injectPane() {
        interp_.setInterpreter(this.beanshellREPLint_);
        this.runPane();
        interp_.resetInterpreter();
    }

    private void runPane() {
        File curFile = model_.getScript(this.scriptTable_.getSelectedRow(), this.scriptTable_.getSelectedColumn());
        if (curFile != null) {
            boolean modified;
            boolean bl = modified = curFile.lastModified() != model_.getLastMod(this.scriptTable_.getSelectedRow(), 0).longValue();
            if (modified) {
                int result = JOptionPane.showConfirmDialog(this, "Script was changed on disk.  Re-load from disk?", APP_NAME, 1, 1);
                switch (result) {
                    case 0: {
                        try {
                            this.readFileToTextArea(curFile, this.scriptArea_);
                            this.scriptFile_ = curFile;
                            this.scriptPaneSaved_ = true;
                            model_.setLastMod(this.scriptTable_.getSelectedRow(), 0, curFile.lastModified());
                        }
                        catch (IOException e) {
                            this.handleException(e);
                        }
                        catch (MMScriptException e) {
                            this.handleException(e);
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
        try {
            this.runButton_.setEnabled(false);
            this.stopButton_.setText("Interrupt");
            this.stopButton_.setEnabled(true);
            interp_.evaluateAsync(this.scriptArea_.getText());
            Thread sentinel = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        interp_.joinEvalThread();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ScriptPanel.this.runButton_.setEnabled(true);
                    ScriptPanel.this.stopButton_.setEnabled(false);
                }
            });
            sentinel.start();
        }
        catch (MMScriptException e) {
            ReportingUtils.logError(e);
            this.messageException(e.getMessage(), -1);
        }
    }

    public static void runFile(File curFile) {
        if (curFile != null) {
            try {
                interp_.evaluateAsync(ScriptPanel.getContents(curFile));
            }
            catch (MMScriptException e) {
                ReportingUtils.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ReportingUtils.logError(ex);
        }
        return contents.toString();
    }

    private void newPane() {
        if (!this.promptToSave(-1)) {
            return;
        }
        int row = this.scriptTable_.getSelectedRow();
        int column = this.scriptTable_.getSelectedColumn();
        this.scriptTable_.changeSelection(row, column, true, false);
        this.scriptArea_.setText("");
        this.scriptPaneSaved_ = true;
        this.scriptFile_ = null;
        this.setTitle("");
        this.scriptArea_.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openScriptInPane() {
        if (!this.promptToSave(-1)) {
            return;
        }
        File curFile = FileDialogs.openFile(this, "Choose Beanshell script", BSH_FILE);
        if (curFile != null) {
            try {
                this.prefs_.put(SCRIPT_FILE, curFile.getAbsolutePath());
                int row = this.scriptTable_.getSelectedRow();
                int column = this.scriptTable_.getSelectedColumn();
                this.scriptTable_.changeSelection(row, column, true, false);
                this.readFileToTextArea(curFile, this.scriptArea_);
                this.scriptFile_ = curFile;
                this.scriptPaneSaved_ = true;
                this.setTitle(curFile.getName());
            }
            catch (IOException e) {
                this.handleException(e);
            }
            catch (MMScriptException e) {
                this.handleException(e);
            }
        }
    }

    public void insertScriptingObject(String varName, Object obj) {
        try {
            interp_.insertGlobalObject(varName, obj);
            this.beanshellREPLint_.set(varName, obj);
        }
        catch (EvalError e) {
            this.handleException((Exception)((Object)e));
        }
        catch (MMScriptException e) {
            this.handleException(e);
        }
    }

    public void setParentGUI(ScriptInterface parent) {
        this.parentGUI_ = parent;
        this.insertScriptingObject("gui", parent);
    }

    private void runImmediatePane() {
        try {
            this.immediatePaneHistory_.add(this.immediatePane_.getText());
            this.immediatePaneHistoryIndex_ = this.immediatePaneHistory_.size();
            interp_.evaluateAsync(this.immediatePane_.getText());
            this.immediatePane_.setText("");
        }
        catch (MMScriptException e) {
            this.messageException(e.getMessage(), -1);
        }
    }

    private void doImmediatePaneHistoryUp() {
        if (this.immediatePaneHistoryIndex_ > 0) {
            --this.immediatePaneHistoryIndex_;
        }
        if (this.immediatePaneHistoryIndex_ >= 0 && this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            this.immediatePane_.setText(this.immediatePaneHistory_.get(this.immediatePaneHistoryIndex_));
        }
    }

    private void doImmediatePaneHistoryDown() {
        if (this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            ++this.immediatePaneHistoryIndex_;
        }
        if (this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            this.immediatePane_.setText(this.immediatePaneHistory_.get(this.immediatePaneHistoryIndex_));
        } else {
            this.immediatePane_.setText("");
        }
    }

    public void closePanel() {
        if (!this.promptToSave(-1)) {
            return;
        }
        this.savePosition();
        this.saveScriptsToPrefs();
        this.dispose();
    }

    public void handleException(Exception e) {
        ReportingUtils.showError((Throwable)e, (Component)this);
    }

    public void message(String text) {
        this.messagePane_.setCharacterAttributes(this.sc_.getStyle(blackStyleName_), false);
        this.messagePane_.replaceSelection(text + "\n");
        this.cons_.print((Object)("\n" + text), Color.black);
        this.showPrompt();
    }

    public void messageException(String text, int lineNumber) {
        if (lineNumber >= 0) {
            this.scriptArea_.setActiveLineRange(lineNumber - 1, lineNumber);
            try {
                this.scriptArea_.select(this.scriptArea_.getLineStartOffset(lineNumber - 1), this.scriptArea_.getLineEndOffset(lineNumber - 1));
            }
            catch (BadLocationException ex) {
                ReportingUtils.logError(ex, "Error in Scriptpanel member function messageException");
            }
        }
        this.messagePane_.setCharacterAttributes(this.sc_.getStyle(redStyleName_), false);
        this.messagePane_.replaceSelection(text + "\n");
        this.cons_.print((Object)("\n" + text), Color.red);
        this.showPrompt();
    }

    private void showPrompt() {
        String promptStr;
        try {
            promptStr = (String)this.beanshellREPLint_.eval("getBshPrompt();");
        }
        catch (EvalError e) {
            ReportingUtils.logError(e);
            promptStr = "bsh % ";
        }
        this.cons_.print((Object)("\n" + promptStr), Color.darkGray);
    }

    public void clearOutput() {
        boolean originalAccessibility = true;
        try {
            this.beanshellREPLint_.eval("bsh.console.text");
        }
        catch (EvalError e) {
            originalAccessibility = false;
            try {
                this.beanshellREPLint_.eval("setAccessibility(true);");
            }
            catch (EvalError e1) {
                ReportingUtils.showError((Throwable)e1, (Component)this);
            }
        }
        try {
            this.beanshellREPLint_.eval("bsh.console.text.setText(\"\");setAccessibility(" + originalAccessibility + ");");
        }
        catch (EvalError e) {
            ReportingUtils.showError((Throwable)e, (Component)this);
        }
    }

    public void ClearOutput() {
        this.clearOutput();
    }

    public void clear() {
        this.clearOutput();
    }

    public void updateGUI() {
        this.parentGUI_.refreshGUI();
    }

    public void getScriptsFromPrefs() {
        String script;
        int j = 0;
        boolean isFile = false;
        do {
            File file;
            if ((script = this.prefs_.get(SCRIPT_FILE + j, null)) != null && !script.equals("") && (file = new File(script)).isFile()) {
                model_.AddScript(file);
                isFile = true;
            }
            ++j;
        } while (script != null && !script.equals("") && isFile);
    }

    public static ArrayList<File> getScriptList() {
        return model_.getFileArray();
    }

    public void saveScriptsToPrefs() {
        ArrayList<File> scriptFileArray = model_.getFileArray();
        for (int i = 0; i < scriptFileArray.size(); ++i) {
            File file = scriptFileArray.get(i);
            if (file == null) continue;
            this.prefs_.put(SCRIPT_FILE + i, file.getAbsolutePath());
        }
        this.prefs_.put(SCRIPT_FILE + scriptFileArray.size(), "");
    }

    private void finishUp() {
        if (!this.promptToSave(-1)) {
            return;
        }
        this.prefs_.putInt(RIGHT_DIVIDER_LOCATION, this.rightSplitPane_.getDividerLocation());
        this.prefs_.putInt(DIVIDER_LOCATION, this.splitPane_.getDividerLocation());
        this.saveScriptsToPrefs();
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        this.finishUp();
        super.dispose();
    }

    private String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.runPane();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void displayMessage(String message) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(message));
        this.gui_.logMessage(message);
    }

    @Override
    public void displayError(String text) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(text, true));
        ReportingUtils.logError(text);
    }

    @Override
    public void displayError(String text, int lineNumber) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(text, true, lineNumber));
        ReportingUtils.logError(text);
    }

    public boolean stopRequestPending() {
        return interp_.stopRequestPending();
    }

    public void sleep(long ms) throws MMScriptException {
        if (ms > 0L) {
            interp_.sleep(ms);
        }
    }

    static {
        BSH_FILE = new FileDialogs.FileType("BSH_FILE", "Beanshell files", System.getProperty("user.home") + "/MyScript.bsh", true, EXT_POS);
    }

    private class ExecuteDisplayMessage
    implements Runnable {
        String msg_;
        boolean error_ = false;
        int lineNumber_ = -1;

        public ExecuteDisplayMessage(String txt, boolean error, int lineNumber) {
            this.msg_ = txt;
            this.error_ = error;
            this.lineNumber_ = lineNumber;
        }

        public ExecuteDisplayMessage(String txt, boolean error) {
            this.msg_ = txt;
            this.error_ = error;
        }

        public ExecuteDisplayMessage(String txt) {
            this.msg_ = txt;
        }

        @Override
        public void run() {
            if (this.error_) {
                ScriptPanel.this.messageException(this.msg_, this.lineNumber_);
            } else {
                ScriptPanel.this.message(this.msg_);
            }
        }
    }

    class immediatePaneListener
    implements ActionListener {
        immediatePaneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ScriptPanel.this.runImmediatePane();
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ScriptPanel.this.scriptPaneSaved_ = false;
            try {
                ScriptPanel.this.scriptArea_.setRows(this.getNumLines(e.getDocument().getText(0, e.getDocument().getLength())));
                ScriptPanel.this.sp.revalidate();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ScriptPanel.this.scriptPaneSaved_ = false;
            try {
                ScriptPanel.this.scriptArea_.setRows(this.getNumLines(e.getDocument().getText(0, e.getDocument().getLength())));
                ScriptPanel.this.sp.revalidate();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private int getNumLines(String text) {
            return text.length() - text.replace("\n", "").length() + 1;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ScriptPanel.this.scriptPaneSaved_ = false;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table_;
        int lastRowSelected_ = -1;
        int lastColumnSelected_ = -1;
        boolean multipleStarted_ = false;

        SelectionListener(JTable table) {
            this.table_ = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() && !this.multipleStarted_) {
                this.multipleStarted_ = true;
                return;
            }
            this.multipleStarted_ = false;
            int row = this.table_.getSelectedRow();
            int column = this.table_.getSelectedColumn();
            if (row >= 0 && model_.isScriptAvailable(row, column) && (row != this.lastRowSelected_ || column != this.lastColumnSelected_)) {
                if (!ScriptPanel.this.promptToSave(this.lastRowSelected_)) {
                    this.table_.changeSelection(this.lastRowSelected_, this.lastColumnSelected_, false, false);
                    return;
                }
                File file = model_.getScript(row, column);
                if (ScriptPanel.EXT_POS.equals(ScriptPanel.this.getExtension(file))) {
                    try {
                        ScriptPanel.this.readFileToTextArea(file, ScriptPanel.this.scriptArea_);
                        ScriptPanel.this.scriptFile_ = file;
                        ScriptPanel.this.scriptPaneSaved_ = true;
                        ScriptPanel.this.setTitle(file.getName());
                        model_.setLastMod(this.table_.getSelectedRow(), 0, file.lastModified());
                    }
                    catch (IOException ee) {
                        ReportingUtils.logError(ee);
                    }
                    catch (MMScriptException ee) {
                        ReportingUtils.logError(ee);
                    }
                } else if (ScriptPanel.EXT_ACQ.equals(ScriptPanel.this.getExtension(file))) {
                    ScriptPanel.this.scriptArea_.setText("gui.loadAcquisition(\"" + file.getAbsolutePath() + "\");\ngui.startAcquisition();");
                    ScriptPanel.this.scriptPaneSaved_ = true;
                }
            }
            this.lastRowSelected_ = row;
            this.lastColumnSelected_ = column;
        }
    }

    private class ScriptTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int columnCount_ = 1;
        private ArrayList<File> scriptFileArray_ = new ArrayList();
        private ArrayList<Long> lastModArray_ = new ArrayList();

        public Boolean HasScriptAlready(File f) {
            Boolean preExisting = false;
            for (File scriptFile : this.scriptFileArray_) {
                if (!scriptFile.getAbsolutePath().equals(f.getAbsolutePath())) continue;
                preExisting = true;
            }
            return preExisting;
        }

        public void AddScript(File f) {
            if (!this.HasScriptAlready(f).booleanValue()) {
                this.scriptFileArray_.add(f);
                this.lastModArray_.add(f.lastModified());
            }
        }

        public void GetCell(File f, int[] cellAddress) {
            int index = this.scriptFileArray_.indexOf(f);
            if (index >= 0) {
                cellAddress[0] = index / 1;
                cellAddress[1] = index % 1;
            }
        }

        public void RemoveScript(int rowNumber, int columnNumber) {
            if (rowNumber >= 0 && this.isScriptAvailable(rowNumber, columnNumber)) {
                this.scriptFileArray_.remove(rowNumber * 1 + columnNumber);
                this.lastModArray_.remove(rowNumber * 1 + columnNumber);
            }
        }

        public File getScript(int rowNumber, int columnNumber) {
            if (rowNumber >= 0 && columnNumber >= 0 && this.isScriptAvailable(rowNumber, columnNumber)) {
                return this.scriptFileArray_.get(rowNumber * 1 + columnNumber);
            }
            return null;
        }

        public Long getLastMod(int rowNumber, int columnNumber) {
            if (rowNumber >= 0 && columnNumber >= 0 && this.isScriptAvailable(rowNumber, columnNumber)) {
                return this.lastModArray_.get(rowNumber * 1 + columnNumber);
            }
            return null;
        }

        public void setLastMod(int rowNumber, int columnNumber, Long lastMod) {
            if (rowNumber >= 0 && columnNumber >= 0 && this.isScriptAvailable(rowNumber, columnNumber)) {
                this.lastModArray_.set(rowNumber * 1 + columnNumber, lastMod);
            }
        }

        public boolean isScriptAvailable(int rowNumber, int columnNumber) {
            return rowNumber >= 0 && columnNumber >= 0 && rowNumber * 1 + columnNumber < this.scriptFileArray_.size();
        }

        public ArrayList<File> getFileArray() {
            return this.scriptFileArray_;
        }

        @Override
        public int getRowCount() {
            if (this.scriptFileArray_ != null) {
                return (int)Math.ceil((double)this.scriptFileArray_.size() / 1.0);
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "Script-Shortcuts";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && this.isScriptAvailable(rowIndex, columnIndex)) {
                return this.scriptFileArray_.get(rowIndex * 1 + columnIndex).getName();
            }
            return null;
        }
    }
}

